/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import org.springframework.core.MethodParameter;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MethodLinkBuilderFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PagedResourcesAssemblerArgumentResolver
implements HandlerMethodArgumentResolver {
    private final HateoasPageableHandlerMethodArgumentResolver resolver;
    private final MethodLinkBuilderFactory<?> linkBuilderFactory;

    public PagedResourcesAssemblerArgumentResolver(HateoasPageableHandlerMethodArgumentResolver resolver, MethodLinkBuilderFactory<?> linkBuilderFactory) {
        this.resolver = resolver;
        this.linkBuilderFactory = linkBuilderFactory == null ? new ControllerLinkBuilderFactory() : linkBuilderFactory;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PagedResourcesAssembler.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Link linkToMethod = this.linkBuilderFactory.linkTo(parameter.getMethod(), new Object[0]).withSelfRel();
        UriComponents fromUriString = UriComponentsBuilder.fromUriString((String)linkToMethod.getHref()).build();
        return new PagedResourcesAssembler(this.resolver, fromUriString);
    }
}

