/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.RepositoryDefinition;
import org.springframework.data.repository.util.ClassUtils;
import org.springframework.util.Assert;

class RepositoryComponentProvider
extends ClassPathScanningCandidateComponentProvider {
    public RepositoryComponentProvider(Iterable<? extends TypeFilter> includeFilters) {
        super(false);
        Assert.notNull(includeFilters);
        if (includeFilters.iterator().hasNext()) {
            for (TypeFilter typeFilter : includeFilters) {
                this.addIncludeFilter(typeFilter);
            }
        } else {
            super.addIncludeFilter((TypeFilter)new InterfaceTypeFilter(Repository.class));
            super.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(RepositoryDefinition.class, true, true));
        }
        this.addExcludeFilter((TypeFilter)new AnnotationTypeFilter(NoRepositoryBean.class));
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        ArrayList<TypeFilter> filterPlusInterface = new ArrayList<TypeFilter>(2);
        filterPlusInterface.add(includeFilter);
        filterPlusInterface.add((TypeFilter)new InterfaceTypeFilter(Repository.class));
        super.addIncludeFilter((TypeFilter)new AllTypeFilter(filterPlusInterface));
        ArrayList<TypeFilter> filterPlusAnnotation = new ArrayList<TypeFilter>(2);
        filterPlusAnnotation.add(includeFilter);
        filterPlusAnnotation.add((TypeFilter)new AnnotationTypeFilter(RepositoryDefinition.class, true, true));
        super.addIncludeFilter((TypeFilter)new AllTypeFilter(filterPlusAnnotation));
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        boolean isNonRepositoryInterface = !ClassUtils.isGenericRepositoryInterface(beanDefinition.getBeanClassName());
        boolean isTopLevelType = !beanDefinition.getMetadata().hasEnclosingClass();
        return isNonRepositoryInterface && isTopLevelType;
    }

    private static class AllTypeFilter
    implements TypeFilter {
        private final List<TypeFilter> delegates;

        public AllTypeFilter(List<TypeFilter> delegates) {
            Assert.notNull(delegates);
            this.delegates = delegates;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            for (TypeFilter filter : this.delegates) {
                if (filter.match(metadataReader, metadataReaderFactory)) continue;
                return false;
            }
            return true;
        }
    }

    private static class InterfaceTypeFilter
    extends AssignableTypeFilter {
        public InterfaceTypeFilter(Class<?> targetType) {
            super(targetType);
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return metadataReader.getClassMetadata().isInterface() && super.match(metadataReader, metadataReaderFactory);
        }
    }
}

