/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.query.ExtensionAwareEvaluationContextProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class RepositoryBeanDefinitionBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryBeanDefinitionBuilder.class);
    private final BeanDefinitionRegistry registry;
    private final RepositoryConfigurationExtension extension;
    private final ResourceLoader resourceLoader;
    private final MetadataReaderFactory metadataReaderFactory;
    private CustomRepositoryImplementationDetector implementationDetector;

    public RepositoryBeanDefinitionBuilder(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, ResourceLoader resourceLoader, Environment environment) {
        Assert.notNull((Object)extension, (String)"RepositoryConfigurationExtension must not be null!");
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null!");
        Assert.notNull((Object)environment, (String)"Environment must not be null!");
        this.registry = registry;
        this.extension = extension;
        this.resourceLoader = resourceLoader;
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        this.implementationDetector = new CustomRepositoryImplementationDetector(this.metadataReaderFactory, environment, resourceLoader);
    }

    public BeanDefinitionBuilder build(RepositoryConfiguration<?> configuration) {
        Assert.notNull((Object)this.registry, (String)"BeanDefinitionRegistry must not be null!");
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null!");
        String factoryBeanName = configuration.getRepositoryFactoryBeanName();
        factoryBeanName = StringUtils.hasText((String)factoryBeanName) ? factoryBeanName : this.extension.getRepositoryFactoryClassName();
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)factoryBeanName);
        builder.getRawBeanDefinition().setSource(configuration.getSource());
        builder.addPropertyValue("repositoryInterface", (Object)configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", configuration.getQueryLookupStrategyKey());
        builder.addPropertyValue("lazyInit", (Object)configuration.isLazyInit());
        builder.addPropertyValue("repositoryBaseClass", (Object)configuration.getRepositoryBaseClassName());
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        if (StringUtils.hasText((String)configuration.getNamedQueriesLocation())) {
            definitionBuilder.setLocations(configuration.getNamedQueriesLocation());
        }
        builder.addPropertyValue("namedQueries", (Object)definitionBuilder.build(configuration.getSource()));
        String customImplementationBeanName = this.registerCustomImplementation(configuration);
        if (customImplementationBeanName != null) {
            builder.addPropertyReference("customImplementation", customImplementationBeanName);
            builder.addDependsOn(customImplementationBeanName);
        }
        RootBeanDefinition evaluationContextProviderDefinition = new RootBeanDefinition(ExtensionAwareEvaluationContextProvider.class);
        evaluationContextProviderDefinition.setSource(configuration.getSource());
        builder.addPropertyValue("evaluationContextProvider", (Object)evaluationContextProviderDefinition);
        return builder;
    }

    private String registerCustomImplementation(RepositoryConfiguration<?> configuration) {
        String beanName = configuration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            return beanName;
        }
        AbstractBeanDefinition beanDefinition = this.implementationDetector.detectCustomImplementation(configuration);
        if (null == beanDefinition) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registering custom repository implementation: " + configuration.getImplementationBeanName() + " " + beanDefinition.getBeanClassName());
        }
        beanDefinition.setSource(configuration.getSource());
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return beanName;
    }
}

