/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

public class ParametersParameterAccessor
implements ParameterAccessor {
    private final Parameters<?, ?> parameters;
    private final Object[] values;

    public ParametersParameterAccessor(Parameters<?, ?> parameters, Object[] values) {
        Assert.notNull(parameters);
        Assert.notNull((Object)values);
        Assert.isTrue((parameters.getNumberOfParameters() == values.length ? 1 : 0) != 0, (String)"Invalid number of parameters given!");
        this.parameters = parameters;
        this.values = (Object[])values.clone();
    }

    public Parameters<?, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Pageable getPageable() {
        if (!this.parameters.hasPageableParameter()) {
            return null;
        }
        return (Pageable)this.values[this.parameters.getPageableIndex()];
    }

    @Override
    public Sort getSort() {
        if (this.parameters.hasSortParameter()) {
            return (Sort)this.values[this.parameters.getSortIndex()];
        }
        if (this.parameters.hasPageableParameter() && this.getPageable() != null) {
            return this.getPageable().getSort();
        }
        return null;
    }

    protected <T> T getValue(int index) {
        return (T)this.values[index];
    }

    @Override
    public Object getBindableValue(int index) {
        return this.values[((Parameter)this.parameters.getBindableParameter(index)).getIndex()];
    }

    @Override
    public boolean hasBindableNullValue() {
        for (Parameter parameter : this.parameters.getBindableParameters()) {
            if (this.values[parameter.getIndex()] != null) continue;
            return true;
        }
        return false;
    }

    public BindableParameterIterator iterator() {
        return new BindableParameterIterator(this);
    }

    private static class BindableParameterIterator
    implements Iterator<Object> {
        private final int bindableParameterCount;
        private final ParameterAccessor accessor;
        private int currentIndex = 0;

        public BindableParameterIterator(ParametersParameterAccessor accessor) {
            Assert.notNull((Object)accessor, (String)"ParametersParameterAccessor must not be null!");
            this.accessor = accessor;
            this.bindableParameterCount = ((Parameters)accessor.getParameters().getBindableParameters()).getNumberOfParameters();
        }

        @Override
        public Object next() {
            return this.accessor.getBindableValue(this.currentIndex++);
        }

        @Override
        public boolean hasNext() {
            return this.bindableParameterCount > this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

