/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.repository.aot.AotQuery;
import org.springframework.data.cassandra.repository.aot.DerivedAotQuery;
import org.springframework.data.cassandra.repository.aot.StringAotQuery;
import org.springframework.data.repository.aot.generate.QueryMetadata;

record CassandraQueryMetadata(AotQuery result) implements QueryMetadata
{
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>();
        AotQuery aotQuery = this.result();
        if (aotQuery instanceof StringAotQuery) {
            StringAotQuery sq = (StringAotQuery)aotQuery;
            serialized.put("query", sq.getQueryString());
        } else {
            aotQuery = this.result();
            if (aotQuery instanceof DerivedAotQuery) {
                DerivedAotQuery dq = (DerivedAotQuery)aotQuery;
                serialized.put("query", dq.getQueryString());
            }
        }
        AotQuery aotQuery2 = this.result();
        if (aotQuery2 instanceof StringAotQuery.NamedStringAotQuery) {
            StringAotQuery.NamedStringAotQuery nsq = (StringAotQuery.NamedStringAotQuery)aotQuery2;
            serialized.put("name", nsq.getQueryName());
        }
        return serialized;
    }
}

