/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import io.micrometer.observation.ObservationRegistry;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.data.cassandra.observability.DefaultCassandraObservationConvention;
import org.springframework.data.cassandra.observability.ObservableCqlSessionFactory;
import org.springframework.data.cassandra.observability.ObservationRequestTracker;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ObservableCqlSessionFactoryBean
extends AbstractFactoryBean<CqlSession> {
    private final CqlSessionBuilder cqlSessionBuilder;
    private final ObservationRegistry observationRegistry;
    private @Nullable String remoteServiceName;
    private CassandraObservationConvention convention = DefaultCassandraObservationConvention.INSTANCE;

    public ObservableCqlSessionFactoryBean(CqlSessionBuilder cqlSessionBuilder, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)cqlSessionBuilder, (String)"CqlSessionBuilder must not be null");
        Assert.notNull((Object)observationRegistry, (String)"ObservationRegistry must not be null");
        this.cqlSessionBuilder = cqlSessionBuilder;
        this.observationRegistry = observationRegistry;
    }

    public @Nullable String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setRemoteServiceName(@Nullable String remoteServiceName) {
        this.remoteServiceName = remoteServiceName;
    }

    public void setConvention(CassandraObservationConvention convention) {
        this.convention = convention;
    }

    protected CqlSession createInstance() {
        this.cqlSessionBuilder.addRequestTracker((RequestTracker)ObservationRequestTracker.INSTANCE);
        String remoteServiceName = ObjectUtils.isEmpty((Object)this.getRemoteServiceName()) ? "Cassandra" : this.getRemoteServiceName();
        return ObservableCqlSessionFactory.wrap((CqlSession)this.cqlSessionBuilder.build(), remoteServiceName, this.convention, this.observationRegistry);
    }

    protected void destroyInstance(@Nullable CqlSession instance) {
        if (instance != null) {
            instance.close();
        }
    }

    public Class<?> getObjectType() {
        return CqlSession.class;
    }
}

