/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Comparator;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentTupleMetadataVerifier;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.MappingException;

public class BasicCassandraPersistentTupleEntity<T>
extends BasicCassandraPersistentEntity<T> {
    public BasicCassandraPersistentTupleEntity(TypeInformation<T> information) {
        super(information, CassandraPersistentTupleMetadataVerifier.INSTANCE, TuplePropertyComparator.INSTANCE);
    }

    @Override
    public void verify() throws MappingException {
        super.verify();
        CassandraPersistentTupleMetadataVerifier.INSTANCE.verify(this);
    }

    @Override
    public boolean isTupleType() {
        return true;
    }

    static enum TuplePropertyComparator implements Comparator<CassandraPersistentProperty>
    {
        INSTANCE;


        @Override
        public int compare(CassandraPersistentProperty propertyOne, CassandraPersistentProperty propertyTwo) {
            return Integer.compare(propertyOne.getRequiredOrdinal(), propertyTwo.getRequiredOrdinal());
        }
    }
}

