/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.aot.AotQuery;
import org.springframework.data.cassandra.repository.aot.DerivedAotQuery;
import org.springframework.data.cassandra.repository.aot.LikeParameterBinding;
import org.springframework.data.cassandra.repository.aot.StringAotQuery;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ParameterBinding;
import org.springframework.data.cassandra.repository.query.WindowUtil;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Sort;
import org.springframework.data.javapoet.LordOfTheStrings;
import org.springframework.data.javapoet.TypeNames;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.Streamable;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.StringUtils;

class CassandraCodeBlocks {
    CassandraCodeBlocks() {
    }

    static QueryBlockBuilder queryBuilder(AotQueryMethodGenerationContext context, CassandraQueryMethod queryMethod) {
        return new QueryBlockBuilder(context, queryMethod);
    }

    static QueryExecutionBlockBuilder executionBuilder(AotQueryMethodGenerationContext context, CustomConversions customConversions, CassandraQueryMethod queryMethod) {
        return new QueryExecutionBlockBuilder(context, customConversions, queryMethod);
    }

    @NullUnmarked
    static class QueryBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final CassandraQueryMethod queryMethod;
        private @Nullable AotQuery query;
        private String queryVariableName;
        private MergedAnnotation<Query> queryAnnotation = MergedAnnotation.missing();

        QueryBlockBuilder(AotQueryMethodGenerationContext context, CassandraQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
        }

        QueryBlockBuilder query(AotQuery query2) {
            this.query = query2;
            return this;
        }

        QueryBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        QueryBlockBuilder query(MergedAnnotation<Query> query2) {
            this.queryAnnotation = query2;
            return this;
        }

        CodeBlock build() {
            AotQuery aotQuery = this.query;
            if (aotQuery instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)aotQuery;
                return this.buildStringQuery(sq);
            }
            aotQuery = this.query;
            if (aotQuery instanceof DerivedAotQuery) {
                DerivedAotQuery derived = (DerivedAotQuery)aotQuery;
                return this.buildDerivedQuery(derived);
            }
            throw new UnsupportedOperationException("Unsupported query: " + String.valueOf(this.query));
        }

        private CodeBlock buildStringQuery(StringAotQuery query2) {
            CodeBlock.Builder builder = CodeBlock.builder();
            String pagingState = null;
            if (StringUtils.hasText((String)this.context.getPageableParameterName())) {
                pagingState = this.context.localVariable("pagingState");
                builder.addStatement("$1T $2L = $3L instanceof $4T $5L ? $5L.getPagingState() : null", new Object[]{ByteBuffer.class, pagingState, this.context.getPageableParameterName(), CassandraPageRequest.class, this.context.localVariable("pageRequest")});
            } else if (StringUtils.hasText((String)this.context.getScrollPositionParameterName())) {
                pagingState = this.context.localVariable("pagingState");
                builder.addStatement("$1T $2L = $3L instanceof $4T $5L && !$5L.isInitial() ? $5L.getPagingState() : null", new Object[]{ByteBuffer.class, pagingState, this.context.getScrollPositionParameterName(), CassandraScrollPosition.class, this.context.localVariable("cassandraScrollPosition")});
            }
            builder.add(this.buildQuery(query2));
            builder.add(this.buildOptions(pagingState));
            return builder.build();
        }

        private CodeBlock buildQuery(StringAotQuery query2) {
            CodeBlock.Builder builder = CodeBlock.builder();
            if (query2.getParameterBindings().isEmpty()) {
                builder.addStatement("$1T $2L = $1T.newInstance($3S)", new Object[]{SimpleStatement.class, this.queryVariableName, query2.getQueryString()});
                return builder.build();
            }
            builder.addStatement("Object[] $L = new Object[$L]", new Object[]{this.context.localVariable("args"), query2.getParameterBindings().size()});
            int index = 0;
            for (ParameterBinding binding : query2.getParameterBindings()) {
                builder.addStatement("$1L[$2L] = $3L", new Object[]{this.context.localVariable("args"), index++, this.getParameter(binding)});
            }
            builder.addStatement("$1T $2L = $1T.newInstance($3S, $4L)", new Object[]{SimpleStatement.class, this.queryVariableName, query2.getQueryString(), this.context.localVariable("args")});
            return builder.build();
        }

        private CodeBlock buildOptions(@Nullable String pagingState) {
            Query.Idempotency idempotent;
            CodeBlock.Builder builder = CodeBlock.builder();
            if (this.queryAnnotation.isPresent() && (idempotent = (Query.Idempotency)this.queryAnnotation.getEnum("idempotent", Query.Idempotency.class)) != Query.Idempotency.UNDEFINED) {
                builder.addStatement("$1L = $1L.setIdempotent($2L)", new Object[]{this.queryVariableName, idempotent == Query.Idempotency.IDEMPOTENT});
            }
            if (StringUtils.hasText((String)pagingState)) {
                builder.addStatement("$1L = $1L.setPagingState($2L)", new Object[]{this.queryVariableName, pagingState});
            }
            if (StringUtils.hasText((String)this.context.getPageableParameterName())) {
                builder.beginControlFlow("if ($1L.isPaged())", new Object[]{this.context.getPageableParameterName()});
                builder.addStatement("$1L = $1L.setPageSize($2L.getPageSize())", new Object[]{this.queryVariableName, this.context.getPageableParameterName()});
                builder.endControlFlow();
            }
            if (StringUtils.hasText((String)this.context.getLimitParameterName())) {
                builder.beginControlFlow("if ($1L.isLimited())", new Object[]{this.context.getLimitParameterName()});
                builder.addStatement("$1L = $1L.setPageSize($2L.max())", new Object[]{this.queryVariableName, this.context.getLimitParameterName()});
                builder.endControlFlow();
            }
            if (this.queryMethod.hasConsistencyLevel()) {
                ConsistencyLevel consistencyLevel = this.queryMethod.getRequiredAnnotatedConsistencyLevel();
                builder.addStatement("$1L = $1L.setConsistencyLevel($2T.$3L)", new Object[]{this.queryVariableName, ConsistencyLevel.class, consistencyLevel.name()});
            }
            return builder.build();
        }

        private CodeBlock buildDerivedQuery(DerivedAotQuery derived) {
            org.springframework.data.cassandra.core.query.Query query2 = derived.getQuery();
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(this.buildQuery(query2));
            builder.add(this.buildColumns(query2.getColumns()));
            builder.add(this.buildSortScrollLimit(derived, query2));
            builder.add(this.buildQueryOptions(derived));
            return builder.build();
        }

        private CodeBlock buildQuery(org.springframework.data.cassandra.core.query.Query query2) {
            CodeBlock.Builder queryBuilder = CodeBlock.builder();
            if (query2.isEmpty()) {
                queryBuilder.addStatement("$1T $2L = $1T.empty()", new Object[]{org.springframework.data.cassandra.core.query.Query.class, this.queryVariableName});
                return queryBuilder.build();
            }
            LordOfTheStrings.CodeBlockBuilder CodeBlockBuilder2 = LordOfTheStrings.builder((CodeBlock.Builder)queryBuilder);
            CodeBlockBuilder2.addStatement(it -> {
                it.add("$1T $2L = $1T.query(", new Object[]{org.springframework.data.cassandra.core.query.Query.class, this.queryVariableName});
                it.addAll((Iterable)((Object)query2), ".and(", criteria -> {
                    LordOfTheStrings.CodeBlockBuilder builder = LordOfTheStrings.builder((String)"$1T.where($2S)", (Object[])new Object[]{Criteria.class, criteria.getColumnName().toCql()});
                    this.appendPredicate((CriteriaDefinition)criteria, builder);
                    builder.add(")", new Object[0]);
                    return builder.build();
                });
            });
            return CodeBlockBuilder2.build();
        }

        private CodeBlock buildColumns(Columns columns) {
            if (columns.isEmpty()) {
                return CodeBlock.builder().build();
            }
            boolean first = true;
            CodeBlock.Builder columnBuilder = CodeBlock.builder();
            columnBuilder.add("$[", new Object[0]);
            columnBuilder.add("$1T $2L = $1T.from(", new Object[]{Columns.class, this.context.localVariable("columns")});
            for (ColumnName column : columns) {
                columnBuilder.add("$S", new Object[]{column.toCql()});
                if (first) {
                    first = false;
                    continue;
                }
                columnBuilder.add(", ", new Object[0]);
            }
            columnBuilder.add(");\n$]", new Object[0]);
            columnBuilder.addStatement("$1L = $1L.columns($2L)", new Object[]{this.queryVariableName, this.context.localVariable("columns")});
            return columnBuilder.build();
        }

        private CodeBlock buildSortScrollLimit(DerivedAotQuery derived, org.springframework.data.cassandra.core.query.Query query2) {
            boolean allowFiltering;
            boolean increaseLimitByOne;
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean bl = increaseLimitByOne = this.queryMethod.isSliceQuery() || this.queryMethod.isScrollQuery();
            if (query2.getSort().isSorted()) {
                builder.addStatement("$1L = $1L.sort($2L)", new Object[]{this.queryVariableName, QueryBlockBuilder.buildSort(query2.getSort())});
            }
            if (derived.isLimited()) {
                builder.addStatement("$1L = $1L.limit($2L)", new Object[]{this.queryVariableName, derived.getLimit().max() + (increaseLimitByOne ? 1 : 0)});
            }
            if (StringUtils.hasText((String)this.context.getLimitParameterName())) {
                if (increaseLimitByOne) {
                    builder.beginControlFlow("if ($1L.isLimited())", new Object[]{this.context.getLimitParameterName()});
                    builder.addStatement("$1L = $1L.limit($2L.max() + 1)", new Object[]{this.queryVariableName, this.context.getLimitParameterName()});
                    builder.endControlFlow();
                } else {
                    builder.addStatement("$1L = $1L.limit($2L)", new Object[]{this.queryVariableName, this.context.getLimitParameterName()});
                }
            }
            if (StringUtils.hasText((String)this.context.getSortParameterName())) {
                builder.addStatement("$1L = $1L.sort($2L)", new Object[]{this.queryVariableName, this.context.getSortParameterName()});
            } else if (StringUtils.hasText((String)this.context.getPageableParameterName())) {
                builder.addStatement("$1L = $1L.pageRequest($2L)", new Object[]{this.queryVariableName, this.context.getPageableParameterName()});
            }
            if (StringUtils.hasText((String)this.context.getScrollPositionParameterName())) {
                builder.beginControlFlow("if (!$1L.isInitial())", new Object[]{this.context.getScrollPositionParameterName()});
                builder.addStatement("$1L = $1L.pagingState(($2T) $3L)", new Object[]{this.queryVariableName, CassandraScrollPosition.class, this.context.getScrollPositionParameterName()});
                builder.endControlFlow();
            }
            if (this.queryAnnotation.isPresent() && (allowFiltering = this.queryAnnotation.getBoolean("allowFiltering"))) {
                builder.addStatement("$1L = $1L.withAllowFiltering()", new Object[]{this.queryVariableName});
            }
            return builder.build();
        }

        private static CodeBlock buildSort(Sort sort) {
            LordOfTheStrings.InvocationBuilder invocation = LordOfTheStrings.invoke((String)"$T.by($L)", (Object[])new Object[]{Sort.class});
            invocation.arguments((Iterable)sort, order -> {
                LordOfTheStrings.CodeBlockBuilder builder = LordOfTheStrings.builder((String)"$T.$L($S)", (Object[])new Object[]{Sort.Order.class, order.isAscending() ? "asc" : "desc", order.getProperty()});
                if (order.isIgnoreCase()) {
                    builder.add(".ignoreCase()", new Object[0]);
                }
                return builder.build();
            });
            return invocation.build();
        }

        private CodeBlock buildQueryOptions(DerivedAotQuery derived) {
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean requiresOptions = StringUtils.hasText((String)this.context.getLimitParameterName()) || StringUtils.hasText((String)this.context.getPageableParameterName()) || derived.isLimited() || this.queryMethod.hasConsistencyLevel() || this.queryMethod.isSliceQuery() | this.queryMethod.isScrollQuery();
            int queryOptionsIndex = this.queryMethod.getParameters().getQueryOptionsIndex();
            if (requiresOptions) {
                if (queryOptionsIndex != -1) {
                    String queryOptions = this.context.getParameterName(queryOptionsIndex);
                    builder.addStatement("$1T $2L = $3L.mutate()", new Object[]{QueryOptions.QueryOptionsBuilder.class, this.context.localVariable("optionsBuilder"), queryOptions});
                } else {
                    builder.addStatement("$1T $2L = $3T.builder()", new Object[]{QueryOptions.QueryOptionsBuilder.class, this.context.localVariable("optionsBuilder"), QueryOptions.class});
                }
                this.applyOptions(derived.getLimit(), builder);
                builder.addStatement("$1L = $1L.queryOptions($2L.build())", new Object[]{this.queryVariableName, this.context.localVariable("optionsBuilder")});
            } else if (queryOptionsIndex != -1) {
                String queryOptions = this.context.getParameterName(queryOptionsIndex);
                builder.addStatement("$1L = $1L.queryOptions($2L)", new Object[]{this.queryVariableName, queryOptions});
            }
            return builder.build();
        }

        private void applyOptions(Limit limit, CodeBlock.Builder builder) {
            if (limit.isLimited()) {
                builder.addStatement("$1L.pageSize($2L)", new Object[]{this.context.localVariable("optionsBuilder"), limit.max()});
            }
            if (StringUtils.hasText((String)this.context.getPageableParameterName())) {
                builder.beginControlFlow("if ($1L.isPaged())", new Object[]{this.context.getPageableParameterName()});
                builder.addStatement("$1L.pageSize($2L.getPageSize())", new Object[]{this.context.localVariable("optionsBuilder"), this.context.getPageableParameterName()});
                builder.endControlFlow();
            }
            if (StringUtils.hasText((String)this.context.getLimitParameterName())) {
                builder.beginControlFlow("if ($1L.isLimited())", new Object[]{this.context.getLimitParameterName()});
                builder.addStatement("$1L.pageSize($2L.max())", new Object[]{this.context.localVariable("optionsBuilder"), this.context.getLimitParameterName()});
                builder.endControlFlow();
            }
            if (this.queryMethod.hasConsistencyLevel()) {
                ConsistencyLevel consistencyLevel = this.queryMethod.getRequiredAnnotatedConsistencyLevel();
                builder.addStatement("$1L.consistencyLevel($2T.$3L)", new Object[]{this.context.localVariable("optionsBuilder"), ConsistencyLevel.class, consistencyLevel.name()});
            }
        }

        private void appendPredicate(CriteriaDefinition criteriaDefinition, LordOfTheStrings.CodeBlockBuilder criteriaBuilder) {
            CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
            if (predicate.getOperator() == CriteriaDefinition.Operators.EQ) {
                criteriaBuilder.add(".is($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.NE) {
                criteriaBuilder.add(".ne($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.GT) {
                criteriaBuilder.add(".gt($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.GTE) {
                criteriaBuilder.add(".gte($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.LT) {
                criteriaBuilder.add(".lt($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.LTE) {
                criteriaBuilder.add(".lte($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.IS_NOT_NULL) {
                criteriaBuilder.add(".isNotNull()", new Object[0]);
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.LIKE) {
                criteriaBuilder.add(".like($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.CONTAINS) {
                criteriaBuilder.add(".contains($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.CONTAINS_KEY) {
                criteriaBuilder.add(".containsKey($L)", new Object[]{this.render(predicate.getValue())});
            } else if (predicate.getOperator() == CriteriaDefinition.Operators.IN) {
                criteriaBuilder.add(".in($L)", new Object[]{this.render(predicate.getValue())});
            } else {
                throw new UnsupportedOperationException("Operator not supported yet: " + String.valueOf(predicate.getOperator()));
            }
        }

        private Object render(@Nullable Object value) {
            if (value instanceof ParameterBinding) {
                ParameterBinding binding = (ParameterBinding)value;
                String parameterName = this.getParameterName(binding);
                if (binding instanceof LikeParameterBinding) {
                    LikeParameterBinding like = (LikeParameterBinding)binding;
                    return switch (like.getType()) {
                        case Part.Type.CONTAINING -> "\"%\" + " + parameterName + " + \"%\"";
                        case Part.Type.STARTING_WITH -> parameterName + " + \"%\"";
                        case Part.Type.ENDING_WITH -> "\"%\" + " + parameterName;
                        default -> parameterName;
                    };
                }
                return parameterName;
            }
            return value != null ? value.toString() : null;
        }

        String getParameterName(ParameterBinding binding) {
            ParameterBinding.ParameterOrigin parameterOrigin = binding.getOrigin();
            if (parameterOrigin instanceof ParameterBinding.MethodInvocationArgument) {
                ParameterBinding.MethodInvocationArgument mia = (ParameterBinding.MethodInvocationArgument)parameterOrigin;
                ParameterBinding.BindingIdentifier identifier = mia.identifier();
                if (identifier.hasPosition()) {
                    return this.context.getParameterName(identifier.getPosition());
                }
                return identifier.getName();
            }
            throw new UnsupportedOperationException("Unsupported origin: " + String.valueOf(binding.getOrigin()));
        }

        private CodeBlock getParameter(ParameterBinding binding) {
            ParameterBinding.ParameterOrigin origin = binding.getOrigin();
            if (origin.isMethodArgument() && origin instanceof ParameterBinding.MethodInvocationArgument) {
                ParameterBinding.MethodInvocationArgument mia = (ParameterBinding.MethodInvocationArgument)origin;
                return CodeBlock.of((String)"potentiallyConvertBindingValue($L)", (Object[])new Object[]{this.getParameterName(binding)});
            }
            if (origin.isExpression() && origin instanceof ParameterBinding.Expression) {
                ParameterBinding.Expression expr = (ParameterBinding.Expression)origin;
                Object expressionString = expr.expression().getExpressionString();
                if (!((String)expressionString).startsWith("$")) {
                    expressionString = "#{" + (String)expressionString + "}";
                }
                return LordOfTheStrings.invoke((String)"evaluateExpression($L)", (Object[])new Object[0]).argument(this.context.getExpressionMarker().enclosingMethod()).argument("$S", new Object[]{expressionString}).arguments((Iterable)this.context.getAllParameterNames()).build();
            }
            throw new UnsupportedOperationException("Not supported yet for: " + String.valueOf(origin));
        }
    }

    @NullUnmarked
    static class QueryExecutionBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final CustomConversions customConversions;
        private final CassandraQueryMethod queryMethod;
        private @Nullable AotQuery query;
        private @Nullable String queryVariableName;

        QueryExecutionBlockBuilder(AotQueryMethodGenerationContext context, CustomConversions customConversions, CassandraQueryMethod queryMethod) {
            this.context = context;
            this.customConversions = customConversions;
            this.queryMethod = queryMethod;
        }

        QueryExecutionBlockBuilder query(AotQuery query2) {
            this.query = query2;
            return this;
        }

        QueryExecutionBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = queryVariableName;
            return this;
        }

        CodeBlock build() {
            boolean streamableResult;
            TypeName actualReturnType;
            CodeBlock.Builder builder = CodeBlock.builder();
            MethodReturn methodReturn = this.context.getMethodReturn();
            boolean isProjecting = !this.query.isCount() && !this.query.isExists() && this.context.getMethodReturn().isProjecting() && !this.customConversions.isSimpleType(this.context.getMethodReturn().toClass()) || StringUtils.hasText((String)this.context.getDynamicProjectionParameterName());
            Class domainType = this.context.getRepositoryInformation().getDomainType();
            builder.add("\n", new Object[0]);
            if (this.query.isDelete()) {
                LordOfTheStrings.InvocationBuilder method = this.query instanceof StringAotQuery ? LordOfTheStrings.invoke((String)"$L.getCqlOperations().execute($L)", (Object[])new Object[]{this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName}) : LordOfTheStrings.invoke((String)"$L.delete($L, $T.class)", (Object[])new Object[]{this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName, domainType});
                if (methodReturn.isVoid()) {
                    builder.addStatement(method.build());
                } else {
                    builder.addStatement(method.assignTo("boolean $L", new Object[]{this.context.localVariable("result")}));
                }
                builder.addStatement(LordOfTheStrings.returning((Class)methodReturn.toClass()).whenBoolean("$L", new Object[]{this.context.localVariable("result")}).build());
                return builder.build();
            }
            boolean isInterfaceProjection = methodReturn.isInterfaceProjection();
            boolean requiresConversion = false;
            boolean isMapProjection = methodReturn.getActualReturnClass().equals(Map.class);
            boolean rawProjection = isMapProjection || methodReturn.toClass().equals(ResultSet.class);
            Object asDynamicTypeNameOrProjectionTypeParameter = actualReturnType = isMapProjection ? methodReturn.getActualClassName() : TypeNames.typeNameOrWrapper((ResolvableType)methodReturn.getActualType());
            if (StringUtils.hasText((String)this.context.getDynamicProjectionParameterName())) {
                asDynamicTypeNameOrProjectionTypeParameter = this.context.getDynamicProjectionParameterName();
            }
            if (this.query instanceof StringAotQuery) {
                if (StringUtils.hasText((String)this.context.getDynamicProjectionParameterName())) {
                    builder.addStatement("$1T<$2T> $3L = $4L.query($5L).as($6L)", new Object[]{ExecutableSelectOperation.TerminatingResults.class, actualReturnType, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName, this.context.getDynamicProjectionParameterName()});
                } else if (isProjecting && !rawProjection) {
                    requiresConversion = isInterfaceProjection;
                    builder.addStatement("$1T<$2T> $3L = $4L.query($5L).as($2T.class)", new Object[]{ExecutableSelectOperation.TerminatingResults.class, requiresConversion ? this.context.getDomainType() : actualReturnType, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName});
                } else if (this.query.isExists() || this.query.isCount()) {
                    builder.addStatement("$1T $2L = $3L.query($4L)", new Object[]{ExecutableSelectOperation.TerminatingProjections.class, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName});
                } else {
                    builder.addStatement("$1T<$2T> $3L = $4L.query($5L).as($2T.class)", new Object[]{ExecutableSelectOperation.TerminatingResults.class, actualReturnType, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName});
                }
            } else if (isProjecting) {
                String as = StringUtils.hasText((String)this.context.getDynamicProjectionParameterName()) ? "$6L" : "$6T.class";
                builder.addStatement("$1T<$2T> $3L = $4L.query($5T.class).as(%s).matching($7L)".formatted(as), new Object[]{ExecutableSelectOperation.TerminatingSelect.class, actualReturnType, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), domainType, asDynamicTypeNameOrProjectionTypeParameter, this.queryVariableName});
            } else {
                builder.addStatement("$1T<$2T> $3L = $4L.query($2T.class).matching($5L)", new Object[]{ExecutableSelectOperation.TerminatingSelect.class, domainType, this.context.localVariable("select"), this.context.fieldNameOf(CassandraOperations.class), this.queryVariableName});
            }
            boolean paginated = StringUtils.hasText((String)this.context.getPageableParameterName()) || StringUtils.hasText((String)this.context.getScrollPositionParameterName()) || StringUtils.hasText((String)this.context.getLimitParameterName());
            boolean bl = streamableResult = this.queryMethod.isScrollQuery() || this.queryMethod.isSliceQuery() || this.queryMethod.isPageQuery() || this.queryMethod.isCollectionQuery() && paginated;
            String terminatingMethod = streamableResult ? "slice()" : (this.queryMethod.isCollectionQuery() ? "all()" : (this.queryMethod.isStreamQuery() ? "stream()" : (this.query.isCount() ? "count()" : (this.query.isExists() ? "count() > 0" : (this.query.isLimited() ? "firstValue()" : "oneValue()")))));
            CodeBlock.Builder execution = CodeBlock.builder();
            if (this.queryMethod.isScrollQuery()) {
                execution.add("$T.of($L.$L)", new Object[]{WindowUtil.class, this.context.localVariable("select"), terminatingMethod});
            } else if (methodReturn.isArray()) {
                execution.add("$L.$L.toArray(new $T[0])", new Object[]{this.context.localVariable("select"), terminatingMethod, methodReturn.getActualClassName()});
            } else if (rawProjection && isMapProjection) {
                execution.add("($T) $L.$L", new Object[]{methodReturn.getClassName(), this.context.localVariable("select"), terminatingMethod});
            } else {
                execution.add("$L.$L", new Object[]{this.context.localVariable("select"), terminatingMethod});
            }
            LordOfTheStrings.TypedReturnBuilder returnBuilder = LordOfTheStrings.returning((Class)methodReturn.toClass());
            if (requiresConversion) {
                String conversionMethod = this.queryMethod.isCollectionQuery() || streamableResult || this.queryMethod.isStreamQuery() ? "convertMany" : "convertOne";
                CodeBlock result = CodeBlock.of((String)"$L($L, $T.class)", (Object[])new Object[]{conversionMethod, execution.build(), actualReturnType});
                if (streamableResult && Collection.class.isAssignableFrom(methodReturn.toClass())) {
                    result = CodeBlock.of((String)"$L.getContent()", (Object[])new Object[]{result});
                } else if (!streamableResult && (QueryExecutionBlockBuilder.isStreamable(methodReturn) || QueryExecutionBlockBuilder.isStreamableWrapper(methodReturn))) {
                    result = CodeBlock.of((String)"$T.of(($T) $L)", (Object[])new Object[]{Streamable.class, Iterable.class, result});
                }
                if (QueryExecutionBlockBuilder.isStreamableWrapper(methodReturn) && this.canConvert(Streamable.class, methodReturn)) {
                    CodeBlock.Builder wrapperBuilder = CodeBlock.builder();
                    builder.addStatement("$1T<$2T> $3L = $4L", new Object[]{Streamable.class, actualReturnType, this.context.localVariable("streamable"), result});
                    builder.addStatement("return ($1T) $2T.getSharedInstance().convert($3L, $4T.valueOf($5T.class), $4T.valueOf($6T.class))", new Object[]{methodReturn.getTypeName(), DefaultConversionService.class, this.context.localVariable("streamable"), TypeDescriptor.class, Streamable.class, methodReturn.toClass()});
                    builder.add(wrapperBuilder.build());
                } else {
                    builder.addStatement(returnBuilder.optional("($T) $L", new Object[]{methodReturn.getTypeName(), result}).build());
                }
            } else {
                CodeBlock executionBlock = execution.build();
                if (this.query.isCount()) {
                    returnBuilder.whenPrimitiveOrBoxed(Integer.class, "(int) $L", new Object[]{executionBlock});
                } else if (streamableResult && Collection.class.isAssignableFrom(methodReturn.toClass())) {
                    executionBlock = CodeBlock.of((String)"$L.getContent()", (Object[])new Object[]{executionBlock});
                } else if (!streamableResult && (QueryExecutionBlockBuilder.isStreamable(methodReturn) || QueryExecutionBlockBuilder.isStreamableWrapper(methodReturn))) {
                    executionBlock = CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{Streamable.class, executionBlock});
                }
                if (QueryExecutionBlockBuilder.isStreamableWrapper(methodReturn) && this.canConvert(Streamable.class, methodReturn)) {
                    builder.addStatement("$1T<$2T> $3L = $4L", new Object[]{Streamable.class, actualReturnType, this.context.localVariable("streamable"), executionBlock});
                    builder.addStatement("return ($1T) $2T.getSharedInstance().convert($3L, $4T.valueOf($5T.class), $4T.valueOf($6T.class))", new Object[]{methodReturn.getTypeName(), DefaultConversionService.class, this.context.localVariable("streamable"), TypeDescriptor.class, Streamable.class, methodReturn.toClass()});
                } else {
                    builder.addStatement(returnBuilder.optional(executionBlock).build());
                }
            }
            return builder.build();
        }

        private boolean canConvert(Class<?> from, MethodReturn methodReturn) {
            return DefaultConversionService.getSharedInstance().canConvert(from, methodReturn.toClass());
        }

        private static boolean isStreamable(MethodReturn methodReturn) {
            return methodReturn.toClass().equals(Streamable.class);
        }

        private static boolean isStreamableWrapper(MethodReturn methodReturn) {
            return !QueryExecutionBlockBuilder.isStreamable(methodReturn) && Streamable.class.isAssignableFrom(methodReturn.toClass());
        }
    }
}

