/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.VectorSort;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class CassandraQueryCreator
extends AbstractQueryCreator<Query, Filter> {
    private static final Log LOG = LogFactory.getLog(CassandraQueryCreator.class);
    private final MappingContext<?, CassandraPersistentProperty> mappingContext;
    private final QueryBuilder queryBuilder = new QueryBuilder();
    private final CassandraParameterAccessor parameterAccessor;
    private final PartTree tree;

    public CassandraQueryCreator(PartTree tree, CassandraParameterAccessor parameterAccessor, MappingContext<?, CassandraPersistentProperty> mappingContext) {
        super(tree, (ParameterAccessor)parameterAccessor);
        Assert.notNull(mappingContext, (String)"CassandraMappingContext must not be null");
        this.tree = tree;
        this.parameterAccessor = parameterAccessor;
        this.mappingContext = mappingContext;
    }

    protected MappingContext<?, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    protected Filter create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.getMappingContext().getPersistentPropertyPath(part.getProperty());
        CassandraPersistentProperty property = (CassandraPersistentProperty)path.getLeafProperty();
        Object filterOrCriteria = this.from(part, property, Criteria.where(path.toDotPath()), iterator);
        if (filterOrCriteria instanceof CriteriaDefinition) {
            return Filter.from((CriteriaDefinition)filterOrCriteria);
        }
        return (Filter)filterOrCriteria;
    }

    protected Filter and(Part part, @Nullable Filter base, Iterator<Object> iterator) {
        if (base != null) {
            Iterator<CriteriaDefinition> iterator2 = base.iterator();
            while (iterator2.hasNext()) {
                CriteriaDefinition criterion = iterator2.next();
                this.getQueryBuilder().and(criterion);
            }
        }
        return this.create(part, (Iterator)iterator);
    }

    protected Filter or(Filter base, Filter criteria) {
        throw new InvalidDataAccessApiUsageException("Cassandra does not support an OR operator");
    }

    protected Query complete(@Nullable Filter criteria, Sort sort) {
        Query query2;
        if (criteria != null) {
            Iterator<CriteriaDefinition> iterator = criteria.iterator();
            while (iterator.hasNext()) {
                CriteriaDefinition criterion = iterator.next();
                this.getQueryBuilder().and(criterion);
            }
        }
        Query query3 = query2 = sort.isUnsorted() && this.parameterAccessor.getVector() != null ? this.getQueryBuilder().create(this.getVectorSort()) : this.getQueryBuilder().create(sort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created query [%s]", query2));
        }
        return query2;
    }

    private Sort getVectorSort() {
        return VectorSort.ann(this.getVectorProperty().toDotPath(), this.parameterAccessor.getVector());
    }

    PropertyPath getVectorProperty() {
        for (PartTree.OrPart parts : this.tree) {
            for (Part part : parts) {
                if (part.getType() != Part.Type.NEAR && part.getType() != Part.Type.WITHIN) continue;
                return part.getProperty();
            }
        }
        throw new IllegalArgumentException("No Near/Within property found");
    }

    private @Nullable Object from(Part part, CassandraPersistentProperty property, Criteria where, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case AFTER: 
            case GREATER_THAN: {
                return where.gt(parameters.next());
            }
            case GREATER_THAN_EQUAL: {
                return where.gte(parameters.next());
            }
            case BEFORE: 
            case LESS_THAN: {
                return where.lt(parameters.next());
            }
            case LESS_THAN_EQUAL: {
                return where.lte(parameters.next());
            }
            case BETWEEN: {
                return CassandraQueryCreator.computeBetweenPart(where, parameters);
            }
            case IN: {
                return where.in(this.nextAsArray(parameters));
            }
            case LIKE: 
            case STARTING_WITH: 
            case ENDING_WITH: {
                return where.like(this.like(type, parameters.next()));
            }
            case CONTAINING: {
                return this.containing(where, property, parameters.next());
            }
            case TRUE: {
                return where.is(true);
            }
            case FALSE: {
                return where.is(false);
            }
            case SIMPLE_PROPERTY: {
                return where.is(parameters.next());
            }
            case NEAR: 
            case WITHIN: {
                Object next = parameters.next();
                if (!(next instanceof Vector)) {
                    throw new IllegalArgumentException("Expected a Vector for Near/Within keyword but got [%s]".formatted(next == null ? "null" : next.getClass()));
                }
                return null;
            }
        }
        throw new InvalidDataAccessApiUsageException(String.format("Unsupported keyword [%s] in part [%s]", type, part));
    }

    private static Filter computeBetweenPart(Criteria where, Iterator<Object> parameters) {
        Object value = parameters.next();
        if (!(value instanceof Range)) {
            return Filter.from(Criteria.where(where.getColumnName()).gt(value), Criteria.where(where.getColumnName()).lt(parameters.next()));
        }
        Range range = (Range)value;
        ArrayList criteria = new ArrayList();
        Optional min = range.getLowerBound().getValue();
        Optional max = range.getUpperBound().getValue();
        min.ifPresent(it -> {
            if (range.getLowerBound().isInclusive()) {
                criteria.add(Criteria.where(where.getColumnName()).gte(it));
            } else {
                criteria.add(Criteria.where(where.getColumnName()).gt(it));
            }
        });
        max.ifPresent(it -> {
            if (range.getUpperBound().isInclusive()) {
                criteria.add(Criteria.where(where.getColumnName()).lte(it));
            } else {
                criteria.add(Criteria.where(where.getColumnName()).lt(it));
            }
        });
        return Filter.from(criteria);
    }

    private CriteriaDefinition containing(Criteria where, CassandraPersistentProperty property, Object bindableValue) {
        if (property.isCollectionLike() || property.isMapLike()) {
            return where.contains(bindableValue);
        }
        return where.like(this.like(Part.Type.CONTAINING, bindableValue));
    }

    protected Object like(Part.Type type, Object value) {
        return switch (type) {
            case Part.Type.LIKE -> value;
            case Part.Type.CONTAINING -> "%" + String.valueOf(value) + "%";
            case Part.Type.STARTING_WITH -> String.valueOf(value) + "%";
            case Part.Type.ENDING_WITH -> "%" + String.valueOf(value);
            default -> throw new IllegalArgumentException(String.format("Part Type [%s] not supported with like queries", type));
        };
    }

    private Object[] nextAsArray(Iterator<Object> iterator) {
        Object next = iterator.next();
        if (next instanceof Collection) {
            return ((Collection)next).toArray();
        }
        if (next.getClass().isArray()) {
            return (Object[])next;
        }
        return new Object[]{next};
    }

    static class QueryBuilder {
        private final List<CriteriaDefinition> criterias = new ArrayList<CriteriaDefinition>();

        QueryBuilder() {
        }

        CriteriaDefinition and(CriteriaDefinition clause) {
            this.criterias.add(clause);
            return clause;
        }

        Query create(Sort sort) {
            Query query2 = Query.query(this.criterias);
            return query2.sort(sort);
        }
    }
}

