/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.data.cassandra.core.EntityLifecycleEventDelegate;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.QueryResultConverter;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.CassandraMappingEvent;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class QueryOperations {
    private final CassandraConverter converter;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final StatementFactory statementFactory;
    private final EntityLifecycleEventDelegate eventDelegate;

    QueryOperations(CassandraConverter converter, StatementFactory statementFactory, EntityLifecycleEventDelegate eventDelegate) {
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.statementFactory = statementFactory;
        this.eventDelegate = eventDelegate;
    }

    public CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityClass) {
        return (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(ClassUtils.getUserClass(entityClass));
    }

    public CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredPersistentEntity(entityClass).getTableName();
    }

    public <T> Selection<T> select(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new DefaultSelection<T>(entityClass);
    }

    public <T> Selection<T> select(Class<T> entityClass, CqlIdentifier tableName) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        Assert.notNull((Object)tableName, (String)"Table name class must not be null");
        return new DefaultSelection<T>(entityClass, tableName);
    }

    public <T> RowMapper<T> getRowMapper(Class<T> domainClass, Statement<?> statement) {
        return this.getRowMapper(domainClass, statement, QueryResultConverter.entity());
    }

    public <T, R> RowMapper<R> getRowMapper(Class<T> domainClass, Statement<?> statement, QueryResultConverter<? super T, ? extends R> mappingFunction) {
        return this.getRowMapper(domainClass, EntityQueryUtils.getTableName(statement), mappingFunction);
    }

    protected <T, R> RowMapper<R> getRowMapper(Class<T> domainClass, CqlIdentifier tableName, QueryResultConverter<? super T, ? extends R> mappingFunction) {
        return this.getRowMapper(this.statementFactory.getEntityProjection(domainClass), tableName, mappingFunction);
    }

    private <T, R> RowMapper<R> getRowMapper(EntityProjection<T, ?> projection, CqlIdentifier tableName, QueryResultConverter<? super T, ? extends R> mappingFunction) {
        Function mapper = this.getMapper(projection, tableName);
        return mappingFunction == QueryResultConverter.entity() ? (row, rowNum) -> mapper.apply(row) : (row, rowNum) -> {
            Lazy reader = Lazy.of(() -> mapper.apply(row));
            return mappingFunction.mapRow(row, () -> ((Lazy)reader).get());
        };
    }

    public <T> Function<Row, T> getMapper(Class<T> domainClass, Statement<?> statement) {
        return this.getMapper(this.statementFactory.getEntityProjection(domainClass), EntityQueryUtils.getTableName(statement));
    }

    private <T> Function<Row, T> getMapper(EntityProjection<T, ?> projection, CqlIdentifier tableName) {
        Class targetType = projection.getMappedType().getType();
        return row -> {
            this.maybeEmitEvent(() -> new AfterLoadEvent((Row)row, targetType, tableName));
            Object result = this.converter.project(projection, (Row)row);
            if (result != null) {
                this.maybeEmitEvent(() -> new AfterConvertEvent<Object>((Row)row, result, tableName));
            }
            return result;
        };
    }

    private <E extends CassandraMappingEvent<T>, T> void maybeEmitEvent(Supplier<E> event) {
        this.eventDelegate.publishEvent(event);
    }

    class DefaultSelection<T>
    implements Selection<T>,
    TerminalSelectExists<T> {
        private final Class<T> entityClass;
        private final CassandraPersistentEntity<?> persistentEntity;
        private final CqlIdentifier tableName;
        private Query query = Query.empty();

        public DefaultSelection(Class<T> entityClass) {
            this.entityClass = entityClass;
            this.persistentEntity = (CassandraPersistentEntity)QueryOperations.this.mappingContext.getRequiredPersistentEntity(entityClass);
            this.tableName = this.persistentEntity.getTableName();
        }

        public DefaultSelection(Class<T> entityClass, CqlIdentifier tableName) {
            this.entityClass = entityClass;
            this.persistentEntity = (CassandraPersistentEntity)QueryOperations.this.mappingContext.getRequiredPersistentEntity(entityClass);
            this.tableName = tableName;
        }

        @Override
        public TerminalSelectExists<T> matching(Query query2) {
            this.query = query2;
            return this;
        }

        @Override
        public TerminalSelectExists<T> matchingId(final Object identifier) {
            return new TerminalSelectExists<T>(this){
                final /* synthetic */ DefaultSelection this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public <V> V exists(Function<Statement<?>, V> function) {
                    SimpleStatement statement = this.this$1.QueryOperations.this.statementFactory.selectExists(identifier, this.this$1.persistentEntity, this.this$1.tableName).build();
                    return function.apply((Statement<?>)statement);
                }

                @Override
                public <V> V select(BiFunction<Statement<?>, RowMapper<T>, V> function) {
                    SimpleStatement statement = this.this$1.QueryOperations.this.statementFactory.selectOneById(identifier, this.this$1.persistentEntity, this.this$1.tableName).build();
                    RowMapper rowMapper = this.this$1.QueryOperations.this.getRowMapper(this.this$1.entityClass, this.this$1.tableName, QueryResultConverter.entity());
                    return function.apply((Statement<?>)statement, rowMapper);
                }
            };
        }

        @Override
        public <P, R> Projection<R> project(Class<P> returnType, QueryResultConverter<? super P, ? extends R> mappingFunction) {
            return new DefaultProjection(this, returnType, mappingFunction);
        }

        @Override
        public <V> V exists(Function<Statement<?>, V> function) {
            StatementBuilder<Select> builder = QueryOperations.this.statementFactory.selectExists(this.query, QueryOperations.this.statementFactory.getEntityProjection(this.entityClass), this.persistentEntity, this.tableName);
            return function.apply((Statement<?>)builder.build());
        }

        @Override
        public <V> V select(BiFunction<Statement<?>, RowMapper<T>, V> function) {
            StatementBuilder<Select> select2 = QueryOperations.this.statementFactory.select(this.query, this.persistentEntity, this.tableName);
            RowMapper mapper = QueryOperations.this.getRowMapper(this.entityClass, this.tableName, QueryResultConverter.entity());
            return function.apply((Statement<?>)select2.build(), mapper);
        }
    }

    class DefaultProjection<E, R, T>
    implements Projection<R>,
    TerminalSelect<R> {
        private final DefaultSelection<E> selection;
        private final Class<T> returnType;
        private final QueryResultConverter<? super T, ? extends R> resultConverter;

        public DefaultProjection(DefaultSelection<E> selection, Class<T> returnType, QueryResultConverter<? super T, ? extends R> resultConverter) {
            this.selection = selection;
            this.returnType = returnType;
            this.resultConverter = resultConverter;
        }

        @Override
        public TerminalSelect<R> matching(Query query2) {
            this.selection.matching(query2);
            return this;
        }

        @Override
        public <V> V select(BiFunction<Statement<?>, RowMapper<R>, V> function) {
            EntityProjection projection = QueryOperations.this.statementFactory.getEntityProjection(this.selection.entityClass, this.returnType);
            StatementBuilder<Select> select2 = QueryOperations.this.statementFactory.select(this.selection.query, projection, this.selection.persistentEntity, this.selection.tableName);
            RowMapper<? extends R> mapper = QueryOperations.this.getRowMapper(projection, this.selection.tableName, this.resultConverter);
            return function.apply((Statement<?>)select2.build(), (RowMapper<R>)mapper);
        }
    }

    static interface TerminalSelect<T> {
        public <V> V select(BiFunction<Statement<?>, RowMapper<T>, V> var1);
    }

    static interface TerminalExists {
        public <V> V exists(Function<Statement<?>, V> var1);
    }

    static interface TerminalSelectExists<T>
    extends TerminalSelect<T>,
    TerminalExists {
    }

    static interface Projection<T> {
        public TerminalSelect<T> matching(Query var1);
    }

    static interface Selection<T> {
        public <P, R> Projection<R> project(Class<P> var1, QueryResultConverter<? super P, ? extends R> var2);

        public TerminalSelectExists<T> matching(Query var1);

        public TerminalSelectExists<T> matchingId(Object var1);
    }
}

