/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.EntityMapping;
import org.springframework.data.cassandra.core.mapping.Mapping;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class CassandraMappingContextParser
extends AbstractSingleBeanDefinitionParser {
    CassandraMappingContextParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CassandraMappingContext.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraMappingContext";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.parseMapping(element, builder, parserContext.getReaderContext().getBeanClassLoader());
        builder.getRawBeanDefinition().setSource((Object)element);
    }

    private void parseMapping(Element element, BeanDefinitionBuilder builder, @Nullable ClassLoader classLoader) {
        String packages = element.getAttribute("entity-base-packages");
        if (StringUtils.hasText((String)packages)) {
            try {
                CassandraEntityClassScanner scanner = new CassandraEntityClassScanner();
                scanner.setBeanClassLoader(classLoader);
                scanner.setEntityBasePackages(StringUtils.commaDelimitedListToSet((String)packages));
                Set<Class<?>> entityClasses = scanner.scanForEntityClasses();
                builder.addPropertyValue("initialEntitySet", entityClasses);
            }
            catch (Exception x) {
                throw new IllegalArgumentException(String.format("encountered exception while scanning for entity classes in package(s) [%s]", packages), x);
            }
        }
        HashSet<EntityMapping> mappings = new HashSet<EntityMapping>();
        DomUtils.getChildElementsByTagName((Element)element, (String)"entity").forEach(entity -> {
            EntityMapping entityMapping = this.parseEntity((Element)entity);
            mappings.add(entityMapping);
        });
        List userTypeResolvers = DomUtils.getChildElementsByTagName((Element)element, (String)"user-type-resolver");
        String userTypeResolverRef = element.getAttribute("user-type-resolver-ref");
        if (StringUtils.hasText((String)userTypeResolverRef)) {
            throw new IllegalArgumentException("user-type-resolver-ref attribute is no longer supported. Please configure the user-type-resolver using the Converter.");
        }
        if (!userTypeResolvers.isEmpty()) {
            throw new IllegalArgumentException("user-type-resolver is no longer supported. Please configure the user-type-resolver using the Converter.");
        }
        Mapping mapping = new Mapping();
        mapping.setEntityMappings(mappings);
        builder.addPropertyValue("mapping", (Object)mapping);
    }

    private EntityMapping parseEntity(Element entity) {
        String className = entity.getAttribute("class");
        Assert.state((boolean)StringUtils.hasText((String)className), (String)"class attribute must not be empty");
        Element table = DomUtils.getChildElementByTagName((Element)entity, (String)"table");
        String tableName = "";
        if (table != null) {
            tableName = table.getAttribute("name");
            tableName = StringUtils.hasText((String)tableName) ? tableName : "";
        }
        Map<String, PropertyMapping> propertyMappings = this.parsePropertyMappings(entity);
        EntityMapping entityMapping = new EntityMapping(className, tableName);
        entityMapping.setPropertyMappings(propertyMappings);
        return entityMapping;
    }

    private Map<String, PropertyMapping> parsePropertyMappings(Element entity) {
        HashMap<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();
        for (Element property : DomUtils.getChildElementsByTagName((Element)entity, (String)"property")) {
            String value = property.getAttribute("name");
            Assert.state((boolean)StringUtils.hasText((String)value), (String)"name attribute must not be empty");
            PropertyMapping propertyMapping = new PropertyMapping(value);
            value = property.getAttribute("column-name");
            if (StringUtils.hasText((String)value)) {
                propertyMapping.setColumnName(value);
            }
            if (StringUtils.hasText((String)(value = property.getAttribute("force-quote")))) {
                throw new IllegalArgumentException("force-quote is no longer supported.");
            }
            propertyMappings.put(propertyMapping.getPropertyName(), propertyMapping);
        }
        return propertyMappings;
    }
}

