/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.AbstractReactiveCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ContextualValueExpressionEvaluator;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.expression.ReactiveValueEvaluationContextProvider;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveStringBasedCassandraQuery
extends AbstractReactiveCassandraQuery {
    private static final String COUNT_AND_EXISTS = "Manually defined query for %s cannot be a count and exists query at the same time";
    private final StringBasedQuery stringBasedQuery;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final ValueExpressionDelegate delegate;
    private final ReactiveValueEvaluationContextProvider valueEvaluationContextProvider;

    public ReactiveStringBasedCassandraQuery(ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations, ValueExpressionDelegate delegate) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, delegate);
    }

    public ReactiveStringBasedCassandraQuery(String query2, ReactiveCassandraQueryMethod method, ReactiveCassandraOperations operations, ValueExpressionDelegate delegate) {
        super(method, operations);
        Assert.hasText((String)query2, (String)"Query must not be empty");
        this.delegate = delegate;
        this.stringBasedQuery = new StringBasedQuery(query2, method.getParameters(), (ValueExpressionParser)delegate);
        ValueEvaluationContextProvider valueContextProvider = delegate.createValueContextProvider((Parameters)method.getParameters());
        Assert.isInstanceOf(ReactiveValueEvaluationContextProvider.class, (Object)valueContextProvider, (String)"ValueEvaluationContextProvider must be reactive");
        this.valueEvaluationContextProvider = (ReactiveValueEvaluationContextProvider)valueContextProvider;
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getRequiredQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            if (ProjectionUtil.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_AND_EXISTS, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
        }
    }

    StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    @Override
    public Mono<SimpleStatement> createQuery(CassandraParameterAccessor parameterAccessor) {
        StringBasedQuery query2 = this.getStringBasedQuery();
        ConvertingParameterAccessor parameterAccessorToUse = new ConvertingParameterAccessor(this.getReactiveCassandraOperations().getConverter(), parameterAccessor);
        return this.getValueExpressionEvaluatorLater(query2.getExpressionDependencies(), parameterAccessor).map(it -> this.getQueryStatementCreator().select(query2, parameterAccessorToUse, (ValueExpressionEvaluator)it));
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    @Override
    protected boolean isModifyingQuery() {
        return false;
    }

    private Mono<ValueExpressionEvaluator> getValueExpressionEvaluatorLater(ExpressionDependencies dependencies, CassandraParameterAccessor accessor) {
        return this.valueEvaluationContextProvider.getEvaluationContextLater((Object)accessor.getValues(), dependencies).map(evaluationContext -> new ContextualValueExpressionEvaluator((ValueExpressionParser)this.delegate, (ValueEvaluationContext)evaluationContext));
    }
}

