/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.type.DataType;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;

public class ConvertingParameterAccessor
implements CassandraParameterAccessor {
    private final CassandraConverter converter;
    private final CassandraParameterAccessor delegate;

    public ConvertingParameterAccessor(CassandraConverter converter, CassandraParameterAccessor delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    @Override
    public CassandraScrollPosition getScrollPosition() {
        return this.delegate.getScrollPosition();
    }

    @Override
    public ScoringFunction getScoringFunction() {
        return this.delegate.getScoringFunction();
    }

    public @Nullable Vector getVector() {
        return this.delegate.getVector();
    }

    public @Nullable Score getScore() {
        return this.delegate.getScore();
    }

    public @Nullable Range<Score> getScoreRange() {
        return this.delegate.getScoreRange();
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Limit getLimit() {
        return this.delegate.getLimit();
    }

    public @Nullable Class<?> findDynamicProjection() {
        return this.delegate.findDynamicProjection();
    }

    public @Nullable Object getBindableValue(int index) {
        return this.potentiallyConvert(index, this.delegate.getBindableValue(index));
    }

    @Override
    public @Nullable CassandraType findCassandraType(int index) {
        return this.delegate.findCassandraType(index);
    }

    @Override
    public @Nullable DataType getDataType(int index) {
        return this.delegate.getDataType(index);
    }

    @Override
    public Class<?> getParameterType(int index) {
        return this.delegate.getParameterType(index);
    }

    @Override
    public @Nullable QueryOptions getQueryOptions() {
        return this.delegate.getQueryOptions();
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    @Override
    public @Nullable Object getValue(int parameterIndex) {
        return this.potentiallyConvert(parameterIndex, this.delegate.getValue(parameterIndex));
    }

    @Nullable Object potentiallyConvert(int index, @Nullable Object bindableValue) {
        if (bindableValue == null) {
            return null;
        }
        if (bindableValue instanceof Range) {
            return bindableValue;
        }
        CassandraType cassandraType = this.delegate.findCassandraType(index);
        if (cassandraType != null) {
            this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(cassandraType));
        }
        return this.converter.convertToColumnType(bindableValue, this.converter.getColumnTypeResolver().resolve(bindableValue));
    }

    private class ConvertingIterator
    implements Iterator<Object> {
        private final Iterator<Object> delegate;
        private int index = 0;

        ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public @Nullable Object next() {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

