/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.converter;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.cql.converter.RowToMapConverter;
import org.springframework.util.Assert;

public class ResultSetToListConverter
implements Converter<ResultSet, List<Map<String, Object>>> {
    private final Converter<Row, Map<String, Object>> rowConverter;

    public ResultSetToListConverter() {
        this(RowToMapConverter.INSTANCE);
    }

    public ResultSetToListConverter(Converter<Row, Map<String, Object>> rowConverter) {
        Assert.notNull(rowConverter, (String)"Converter must not be null");
        this.rowConverter = rowConverter;
    }

    public List<@Nullable Map<String, @Nullable Object>> convert(ResultSet resultSet) {
        ArrayList<@Nullable Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Row row : resultSet) {
            list.add((Map)this.rowConverter.convert((Object)row));
        }
        return list;
    }
}

