/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.repository.support.ReactiveCassandraRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class ReactiveCassandraRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private boolean mappingContextConfigured = false;
    private @Nullable ReactiveCassandraOperations operations;

    public ReactiveCassandraRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setReactiveCassandraOperations(ReactiveCassandraOperations operations) {
        this.operations = operations;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        Assert.state((this.operations != null ? 1 : 0) != 0, (String)"ReactiveCassandraOperations must not be null");
        return this.getFactoryInstance(this.operations);
    }

    protected RepositoryFactorySupport getFactoryInstance(ReactiveCassandraOperations operations) {
        return new ReactiveCassandraRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.operations, (String)"ReactiveCassandraOperations must not be null");
        if (!this.mappingContextConfigured) {
            this.setMappingContext((MappingContext<?, ?>)this.operations.getConverter().getMappingContext());
        }
    }
}

