/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class ExecutableSelectOperationSupport
implements ExecutableSelectOperation {
    private final CassandraTemplate template;

    public ExecutableSelectOperationSupport(CassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableSelectSupport<T>(this.template, domainType, domainType, Query.empty(), null);
    }

    static class ExecutableSelectSupport<T>
    implements ExecutableSelectOperation.ExecutableSelect<T> {
        private final CassandraTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final Query query;
        private final @Nullable CqlIdentifier tableName;

        public ExecutableSelectSupport(CassandraTemplate template, Class<?> domainType, Class<T> returnType, Query query2, @Nullable CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public ExecutableSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableSelectSupport<T>(this.template, this.domainType, this.returnType, this.query, tableName);
        }

        @Override
        public <R> ExecutableSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ExecutableSelectSupport<R>(this.template, this.domainType, returnType, this.query, this.tableName);
        }

        @Override
        public ExecutableSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableSelectSupport<T>(this.template, this.domainType, this.returnType, query2, this.tableName);
        }

        @Override
        public long count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public boolean exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public @Nullable T firstValue() {
            List<T> result = this.template.doSelect(this.query.limit(1L), this.domainType, this.getTableName(), this.returnType);
            return ObjectUtils.isEmpty(result) ? null : (T)result.iterator().next();
        }

        @Override
        public @Nullable T oneValue() {
            List<T> result = this.template.doSelect(this.query.limit(2L), this.domainType, this.getTableName(), this.returnType);
            if (ObjectUtils.isEmpty(result)) {
                return null;
            }
            if (result.size() > 1) {
                throw new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result", this.query), 1);
            }
            return result.iterator().next();
        }

        @Override
        public List<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType);
        }

        @Override
        public Stream<T> stream() {
            return this.template.doStream(this.query, this.domainType, this.getTableName(), this.returnType);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

