/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.SerializationUtils;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Update {
    private static final Update EMPTY = new Update(Collections.emptyList());
    private final List<AssignmentOp> updateOperations;

    public static Update empty() {
        return EMPTY;
    }

    public static Update of(Iterable<AssignmentOp> assignmentOps) {
        int n;
        Assert.notNull(assignmentOps, (String)"Update operations must not be null");
        if (assignmentOps instanceof Collection) {
            Collection c = (Collection)assignmentOps;
            n = c.size();
        } else {
            n = 16;
        }
        ArrayList<AssignmentOp> updateOperations = new ArrayList<AssignmentOp>(n);
        assignmentOps.forEach(updateOperations::add);
        return new Update(updateOperations);
    }

    public static Update update(String columnName, @Nullable Object value) {
        return Update.empty().set(columnName, value);
    }

    private Update(List<AssignmentOp> updateOperations) {
        this.updateOperations = updateOperations;
    }

    @CheckReturnValue
    public Update set(String columnName, @Nullable Object value) {
        return this.add(new SetOp(ColumnName.from(columnName), value));
    }

    @CheckReturnValue
    public SetBuilder set(String columnName) {
        return new DefaultSetBuilder(ColumnName.from(columnName));
    }

    @CheckReturnValue
    public AddToBuilder addTo(String columnName) {
        return new DefaultAddToBuilder(ColumnName.from(columnName));
    }

    @CheckReturnValue
    public RemoveFromBuilder removeFrom(String columnName) {
        return new DefaultRemoveFromBuilder(ColumnName.from(columnName));
    }

    @CheckReturnValue
    public Update remove(String columnName, Object value) {
        return this.add(new RemoveOp(ColumnName.from(columnName), Collections.singletonList(value)));
    }

    @CheckReturnValue
    public Update clear(String columnName) {
        return this.add(new SetOp(ColumnName.from(columnName), Collections.emptyList()));
    }

    @CheckReturnValue
    public Update increment(String columnName) {
        return this.increment(columnName, 1);
    }

    @CheckReturnValue
    public Update increment(String columnName, Number delta) {
        return this.add(new IncrOp(ColumnName.from(columnName), delta));
    }

    @CheckReturnValue
    public Update decrement(String columnName) {
        return this.decrement(columnName, 1);
    }

    @CheckReturnValue
    public Update decrement(String columnName, Number delta) {
        if (delta instanceof Integer || delta instanceof Long) {
            long deltaValue = delta.longValue() > 0L ? -Math.abs(delta.longValue()) : delta.longValue();
            return this.add(new IncrOp(ColumnName.from(columnName), deltaValue));
        }
        double deltaValue = delta.doubleValue();
        deltaValue = deltaValue > 0.0 ? -Math.abs(deltaValue) : deltaValue;
        return this.add(new IncrOp(ColumnName.from(columnName), deltaValue));
    }

    public Collection<AssignmentOp> getUpdateOperations() {
        return Collections.unmodifiableCollection(this.updateOperations);
    }

    private Update add(AssignmentOp assignmentOp) {
        ArrayList<AssignmentOp> list = new ArrayList<AssignmentOp>(this.updateOperations.size() + 1);
        for (AssignmentOp existing : this.updateOperations) {
            if (assignmentOp.overrides(existing)) continue;
            list.add(existing);
        }
        list.add(assignmentOp);
        return new Update(list);
    }

    public String toString() {
        return StringUtils.collectionToDelimitedString(this.updateOperations, (String)", ");
    }

    public static class SetOp
    extends AssignmentOp {
        @Nullable
        private final Object value;

        public SetOp(ColumnName columnName, @Nullable Object value) {
            super(columnName);
            this.value = value;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }
    }

    public static abstract class AssignmentOp {
        private final ColumnName columnName;

        protected AssignmentOp(ColumnName columnName) {
            this.columnName = columnName;
        }

        public ColumnName getColumnName() {
            return this.columnName;
        }

        public CqlIdentifier toCqlIdentifier() {
            return this.columnName.getCqlIdentifier().orElseGet(() -> CqlIdentifier.fromCql((String)this.columnName.toCql()));
        }

        boolean overrides(AssignmentOp other) {
            return ObjectUtils.nullSafeEquals((Object)this.columnName, (Object)other.columnName);
        }
    }

    private class DefaultSetBuilder
    implements SetBuilder {
        private final ColumnName columnName;

        DefaultSetBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public SetValueBuilder atIndex(int index) {
            return value -> Update.this.add(new SetAtIndexOp(this.columnName, index, value));
        }

        @Override
        public SetValueBuilder atKey(Object key) {
            return value -> Update.this.add(new SetAtKeyOp(this.columnName, key, value));
        }
    }

    private class DefaultAddToBuilder
    implements AddToBuilder {
        private final ColumnName columnName;

        DefaultAddToBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public Update prepend(Object value) {
            return this.prependAll(Collections.singletonList(value));
        }

        @Override
        public Update prependAll(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.prependAll(Arrays.asList(values));
        }

        @Override
        public Update prependAll(Iterable<? extends Object> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new AddToOp(this.columnName, values, AddToOp.Mode.PREPEND));
        }

        @Override
        public Update append(Object value) {
            return this.appendAll(Collections.singletonList(value));
        }

        @Override
        public Update appendAll(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.appendAll(Arrays.asList(values));
        }

        @Override
        public Update appendAll(Iterable<? extends Object> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new AddToOp(this.columnName, values, AddToOp.Mode.APPEND));
        }

        @Override
        public Update entry(Object key, Object value) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            Assert.notNull((Object)value, (String)"Value must not be null");
            return this.addAll(Collections.singletonMap(key, value));
        }

        public Update addAll(Map<?, ?> map) {
            Assert.notNull(map, (String)"Map must not be null");
            return Update.this.add(new AddToMapOp(this.columnName, map));
        }
    }

    private class DefaultRemoveFromBuilder
    implements RemoveFromBuilder {
        private final ColumnName columnName;

        DefaultRemoveFromBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public Update value(Object value) {
            return Update.this.add(new RemoveOp(this.columnName, value));
        }

        public Update values(Iterable<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new RemoveOp(this.columnName, values));
        }
    }

    public static class RemoveOp
    extends AssignmentOp {
        private final Object value;

        public RemoveOp(ColumnName columnName, Object value) {
            super(columnName);
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        boolean overrides(AssignmentOp other) {
            return false;
        }

        public String toString() {
            return String.format("%s = %s - %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class IncrOp
    extends AssignmentOp {
        private final Number value;

        public IncrOp(ColumnName columnName, Number value) {
            super(columnName);
            this.value = value;
        }

        public Number getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s %s %d", this.getColumnName(), this.getColumnName(), this.value.doubleValue() > 0.0 ? "+" : "-", Math.abs(this.value.longValue()));
        }
    }

    public static class SetAtKeyOp
    extends SetOp {
        private final Object key;
        private final Object value;

        public SetAtKeyOp(ColumnName columnName, Object key, Object value) {
            super(columnName, value);
            Assert.notNull((Object)key, (String)"Key must not be null");
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        boolean overrides(AssignmentOp other) {
            if (super.overrides(other)) {
                if (other instanceof SetAtKeyOp) {
                    SetAtKeyOp i = (SetAtKeyOp)other;
                    return ObjectUtils.nullSafeEquals((Object)this.getKey(), (Object)i.getKey());
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return String.format("%s[%s] = %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.key), SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class SetAtIndexOp
    extends SetOp {
        private final int index;

        public SetAtIndexOp(ColumnName columnName, int index, Object value) {
            super(columnName, value);
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        boolean overrides(AssignmentOp other) {
            if (super.overrides(other)) {
                if (other instanceof SetAtIndexOp) {
                    SetAtIndexOp i = (SetAtIndexOp)other;
                    return this.getIndex() == i.getIndex();
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return String.format("%s[%d] = %s", this.getColumnName(), this.index, SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class AddToMapOp
    extends AssignmentOp {
        private final Map<Object, Object> value;

        public AddToMapOp(ColumnName columnName, Map<? extends Object, ? extends Object> value) {
            super(columnName);
            this.value = value;
        }

        public Map<Object, Object> getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s + %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }
    }

    public static class AddToOp
    extends AssignmentOp {
        private final Iterable<Object> value;
        private final Mode mode;

        public AddToOp(ColumnName columnName, Iterable<? extends Object> value, Mode mode) {
            super(columnName);
            this.value = value;
            this.mode = mode;
        }

        public Iterable<Object> getValue() {
            return this.value;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String toString() {
            return Mode.PREPEND.equals((Object)this.getMode()) ? String.format("%s = %s + %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value), this.getColumnName()) : String.format("%s = %s + %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }

        public static enum Mode {
            PREPEND,
            APPEND;

        }
    }

    public static interface SetValueBuilder {
        public Update to(Object var1);
    }

    public static interface SetBuilder {
        public SetValueBuilder atIndex(int var1);

        public SetValueBuilder atKey(Object var1);
    }

    public static interface RemoveFromBuilder {
        public Update value(Object var1);

        default public Update values(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.values(Arrays.asList(values));
        }

        public Update values(Iterable<? extends Object> var1);
    }

    public static interface AddToBuilder {
        public Update prepend(Object var1);

        public Update prependAll(Object ... var1);

        public Update prependAll(Iterable<? extends Object> var1);

        public Update append(Object var1);

        public Update appendAll(Object ... var1);

        public Update appendAll(Iterable<? extends Object> var1);

        public Update entry(Object var1, Object var2);

        public Update addAll(Map<? extends Object, ? extends Object> var1);
    }
}

