/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.PartTreeCassandraQuery;
import org.springframework.data.cassandra.repository.query.StringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.SimpleCassandraRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class CassandraRepositoryFactory
extends RepositoryFactorySupport {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CassandraOperations operations;

    public CassandraRepositoryFactory(CassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.operations = operations;
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    protected ProjectionFactory getProjectionFactory(ClassLoader classLoader, BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    public <T, ID> CassandraEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCassandraEntityInformation(entity, this.operations.getConverter());
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new CassandraQueryLookupStrategy(this.operations, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate), this.mappingContext));
    }

    private record CassandraQueryLookupStrategy(CassandraOperations operations, ValueExpressionDelegate valueExpressionDelegate, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) implements QueryLookupStrategy
    {
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CassandraQueryMethod queryMethod = new CassandraQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedCassandraQuery(namedQuery, queryMethod, this.operations, this.valueExpressionDelegate);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedCassandraQuery(queryMethod, this.operations, this.valueExpressionDelegate);
            }
            return new PartTreeCassandraQuery(queryMethod, this.operations);
        }
    }
}

