/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.AbstractCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCassandraQuery
extends AbstractCassandraQuery {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final PartTree tree;
    private final StatementFactory statementFactory;

    public PartTreeCassandraQuery(CassandraQueryMethod queryMethod, CassandraOperations operations) {
        super(queryMethod, operations);
        StatementFactory statementFactory;
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getResultProcessor().getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
        if (operations instanceof CassandraTemplate) {
            CassandraTemplate ct = (CassandraTemplate)operations;
            statementFactory = ct.getStatementFactory();
        } else {
            statementFactory = new StatementFactory(new UpdateMapper(operations.getConverter()));
        }
        this.statementFactory = statementFactory;
    }

    @Override
    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    protected PartTree getTree() {
        return this.tree;
    }

    @Override
    protected SimpleStatement createQuery(CassandraParameterAccessor parameterAccessor) {
        if (this.isCountQuery()) {
            return this.getQueryStatementCreator().count(this.getStatementFactory(), this.getTree(), parameterAccessor);
        }
        if (this.isExistsQuery()) {
            return this.getQueryStatementCreator().exists(this.getStatementFactory(), this.getTree(), parameterAccessor);
        }
        if (this.getTree().isDelete()) {
            return this.getQueryStatementCreator().delete(this.getStatementFactory(), this.getTree(), parameterAccessor);
        }
        return this.getQueryStatementCreator().select(this.getStatementFactory(), this.getTree(), parameterAccessor, this.getQueryMethod().getResultProcessor());
    }

    @Override
    protected boolean isCountQuery() {
        return this.getTree().isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.getTree().isExistsProjection();
    }

    @Override
    protected boolean isLimiting() {
        return this.getTree().isLimiting();
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getTree().isDelete();
    }
}

