/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.convert.CassandraColumnType;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.DefaultColumnType;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;

class DefaultCassandraColumnType
extends DefaultColumnType
implements CassandraColumnType {
    private final Lazy<DataType> dataType;

    DefaultCassandraColumnType(Class<?> type, DataType dataType, ColumnType ... parameters) {
        this(TypeInformation.of(type), dataType, parameters);
    }

    DefaultCassandraColumnType(TypeInformation<?> typeInformation, Supplier<DataType> dataType, ColumnType ... parameters) {
        super(typeInformation, parameters);
        this.dataType = Lazy.of(dataType);
    }

    DefaultCassandraColumnType(TypeInformation<?> typeInformation, DataType dataType, ColumnType ... parameters) {
        super(typeInformation, parameters);
        this.dataType = Lazy.of((Object)dataType);
    }

    @Override
    public DataType getDataType() {
        return (DataType)this.dataType.get();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isTupleType()) {
            builder.append("Tuple: ");
        }
        if (this.isUserDefinedType()) {
            builder.append("UDT: ").append(((UserDefinedType)this.getDataType()).getName());
        }
        builder.append(this.getType().getName()).append(" [").append(this.getDataType()).append("]");
        if (this.getParameters().isEmpty()) {
            return builder.toString();
        }
        builder.append("<").append(this.getParameters().stream().map(Object::toString).collect(Collectors.toList())).append(">");
        return builder.toString();
    }
}

