/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.query.AbstractReactiveCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.parser.PartTree;
import reactor.core.publisher.Mono;

public class ReactivePartTreeCassandraQuery
extends AbstractReactiveCassandraQuery {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final PartTree tree;
    private final StatementFactory statementFactory;

    public ReactivePartTreeCassandraQuery(ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations) {
        super(queryMethod, operations);
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getResultProcessor().getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
        this.statementFactory = new StatementFactory(new UpdateMapper(operations.getConverter()));
    }

    @Override
    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    protected PartTree getTree() {
        return this.tree;
    }

    @Override
    protected Mono<SimpleStatement> createQuery(CassandraParameterAccessor parameterAccessor) {
        return Mono.fromSupplier(() -> {
            if (this.isCountQuery()) {
                return this.getQueryStatementCreator().count(this.getStatementFactory(), this.getTree(), parameterAccessor);
            }
            if (this.isExistsQuery()) {
                return this.getQueryStatementCreator().exists(this.getStatementFactory(), this.getTree(), parameterAccessor);
            }
            if (this.getTree().isDelete()) {
                return this.getQueryStatementCreator().delete(this.getStatementFactory(), this.getTree(), parameterAccessor);
            }
            return this.getQueryStatementCreator().select(this.getStatementFactory(), this.getTree(), parameterAccessor, this.getQueryMethod().getResultProcessor());
        });
    }

    @Override
    protected boolean isCountQuery() {
        return this.getTree().isCountProjection();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.getTree().isExistsProjection();
    }

    @Override
    protected boolean isLimiting() {
        return this.getTree().isLimiting();
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getTree().isDelete();
    }
}

