/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.SchemaFactory;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraAdminTemplate
extends CassandraTemplate
implements CassandraAdminOperations {
    protected static final boolean DEFAULT_DROP_TABLE_IF_EXISTS = false;
    private final SchemaFactory schemaFactory = new SchemaFactory(this.getConverter());

    public CassandraAdminTemplate(CqlSession session) {
        super(session);
    }

    public CassandraAdminTemplate(CqlSession session, CassandraConverter converter) {
        super(session, converter);
    }

    public CassandraAdminTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        super(sessionFactory, converter);
    }

    public CassandraAdminTemplate(CqlOperations cqlOperations, CassandraConverter converter) {
        super(cqlOperations, converter);
    }

    @Override
    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    @Override
    public void createTable(boolean ifNotExists, CqlIdentifier tableName, Class<?> entityClass, Map<String, Object> optionsByName) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getConverter().getMappingContext().getRequiredPersistentEntity(entityClass);
        CreateTableSpecification createTableSpecification = this.schemaFactory.getCreateTableSpecificationFor(entity, tableName).ifNotExists(ifNotExists);
        this.getCqlOperations().execute(CreateTableCqlGenerator.toCql(createTableSpecification));
    }

    @Override
    public void dropTable(Class<?> entityClass) {
        this.dropTable(this.getTableName(entityClass));
    }

    @Override
    public void dropTable(CqlIdentifier tableName) {
        this.dropTable(false, tableName);
    }

    @Override
    public void dropTable(boolean ifExists, CqlIdentifier tableName) {
        String dropTableCql = DropTableCqlGenerator.toCql(DropTableSpecification.dropTable(tableName).ifExists(ifExists));
        this.getCqlOperations().execute(dropTableCql);
    }

    @Override
    public void dropUserType(CqlIdentifier typeName) {
        Assert.notNull((Object)typeName, (String)"Type name must not be null");
        String dropUserTypeCql = DropUserTypeCqlGenerator.toCql(DropUserTypeSpecification.dropType(typeName));
        this.getCqlOperations().execute(dropUserTypeCql);
    }

    @Override
    public Optional<TableMetadata> getTableMetadata(CqlIdentifier keyspace, CqlIdentifier tableName) {
        Assert.notNull((Object)keyspace, (String)"Keyspace name must not be null");
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        return this.getCqlOperations().execute((CqlSession session) -> session.getMetadata().getKeyspace(keyspace).flatMap(it -> it.getTable(tableName)));
    }

    @Override
    public KeyspaceMetadata getKeyspaceMetadata() {
        return this.getCqlOperations().execute((CqlSession session) -> (KeyspaceMetadata)session.getKeyspace().flatMap(it -> session.getMetadata().getKeyspace(it)).orElseThrow(() -> new IllegalStateException("Metadata for keyspace not available")));
    }
}

