/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.util.Assert;

@Deprecated
public class CachedPreparedStatementCreator
implements PreparedStatementCreator {
    private static final Map<CqlSession, Map<String, PreparedStatement>> CACHE = new ConcurrentHashMap<CqlSession, Map<String, PreparedStatement>>();
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String cql;

    public CachedPreparedStatementCreator(String cql) {
        Assert.hasText((String)cql, (String)"CQL is required to create a PreparedStatement");
        this.cql = cql;
    }

    public String getCql() {
        return this.cql;
    }

    @Override
    public PreparedStatement createPreparedStatement(CqlSession session) throws DriverException {
        CqlIdentifier keyspace = session.getKeyspace().orElse(CqlIdentifier.fromCql((String)"unknown"));
        String cacheKey = keyspace.asInternal().concat("|").concat(this.cql);
        this.log.debug((Object)String.format("Cacheable PreparedStatement in Keyspace %s", keyspace.asCql(true)));
        Map<String, PreparedStatement> sessionCache = this.getOrCreateSessionLocalCache(session);
        return this.getOrPrepareStatement(session, cacheKey, sessionCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, PreparedStatement> getOrCreateSessionLocalCache(CqlSession session) {
        Map<String, PreparedStatement> sessionMap = CACHE.get(session);
        if (sessionMap == null) {
            CqlSession cqlSession = session;
            synchronized (cqlSession) {
                if (CACHE.containsKey(session)) {
                    sessionMap = CACHE.get(session);
                } else {
                    sessionMap = new ConcurrentHashMap<String, PreparedStatement>();
                    CACHE.put(session, sessionMap);
                }
            }
        }
        return sessionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getOrPrepareStatement(CqlSession session, String cacheKey, Map<String, PreparedStatement> sessionCache) {
        PreparedStatement preparedStatement = sessionCache.get(cacheKey);
        if (preparedStatement == null) {
            Map<String, PreparedStatement> map = sessionCache;
            synchronized (map) {
                if (sessionCache.containsKey(cacheKey)) {
                    this.log.debug((Object)"Found cached PreparedStatement");
                    preparedStatement = sessionCache.get(cacheKey);
                } else {
                    this.log.debug((Object)"No cached PreparedStatement found... creating and caching");
                    preparedStatement = session.prepare(this.cql);
                    sessionCache.put(cacheKey, preparedStatement);
                }
            }
        }
        return preparedStatement;
    }
}

