/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.AlreadyExistsException;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.InvalidConfigurationInQueryException;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.SyntaxError;
import com.datastax.oss.driver.api.core.servererrors.TruncateException;
import com.datastax.oss.driver.api.core.servererrors.UnauthorizedException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.cassandra.CassandraAuthenticationException;
import org.springframework.data.cassandra.CassandraConnectionFailureException;
import org.springframework.data.cassandra.CassandraInsufficientReplicasAvailableException;
import org.springframework.data.cassandra.CassandraInvalidConfigurationInQueryException;
import org.springframework.data.cassandra.CassandraInvalidQueryException;
import org.springframework.data.cassandra.CassandraQuerySyntaxException;
import org.springframework.data.cassandra.CassandraReadTimeoutException;
import org.springframework.data.cassandra.CassandraSchemaElementExistsException;
import org.springframework.data.cassandra.CassandraTruncateException;
import org.springframework.data.cassandra.CassandraUnauthorizedException;
import org.springframework.data.cassandra.CassandraUncategorizedException;
import org.springframework.data.cassandra.CassandraWriteTimeoutException;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraExceptionTranslator
implements CqlExceptionTranslator {
    private static final Set<String> CONNECTION_FAILURE_TYPES = new HashSet<String>(Arrays.asList("NoHostAvailableException", "ConnectionException", "OperationTimedOutException", "TransportException", "BusyConnectionException", "BusyPoolException"));
    private static final Set<String> RESOURCE_FAILURE_TYPES = new HashSet<String>(Arrays.asList("ReadFailureException", "WriteFailureException", "FunctionExecutionException"));

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        if (exception instanceof DataAccessException) {
            return (DataAccessException)exception;
        }
        return this.translate(null, null, exception);
    }

    @Override
    public DataAccessException translate(@Nullable String task, @Nullable String cql, RuntimeException exception) {
        String message = this.buildMessage(task, cql, exception);
        if (exception instanceof AuthenticationException) {
            return new CassandraAuthenticationException(((AuthenticationException)exception).getEndPoint(), message, exception);
        }
        if (exception instanceof ReadTimeoutException) {
            return new CassandraReadTimeoutException(((ReadTimeoutException)exception).wasDataPresent(), message, exception);
        }
        if (exception instanceof WriteTimeoutException) {
            WriteType writeType = ((WriteTimeoutException)exception).getWriteType();
            return new CassandraWriteTimeoutException(writeType == null ? null : writeType.name(), message, exception);
        }
        if (exception instanceof TruncateException) {
            return new CassandraTruncateException(message, exception);
        }
        if (exception instanceof UnavailableException) {
            UnavailableException ux = (UnavailableException)exception;
            return new CassandraInsufficientReplicasAvailableException(ux.getRequired(), ux.getAlive(), message, exception);
        }
        if (exception instanceof OverloadedException || exception instanceof BootstrappingException) {
            return new TransientDataAccessResourceException(message, (Throwable)exception);
        }
        if (exception instanceof AlreadyExistsException) {
            AlreadyExistsException aex = (AlreadyExistsException)exception;
            return new CassandraSchemaElementExistsException(aex.getMessage(), (Throwable)aex);
        }
        if (exception instanceof InvalidConfigurationInQueryException) {
            return new CassandraInvalidConfigurationInQueryException(message, exception);
        }
        if (exception instanceof InvalidQueryException) {
            return new CassandraInvalidQueryException(message, exception);
        }
        if (exception instanceof SyntaxError) {
            return new CassandraQuerySyntaxException(message, exception);
        }
        if (exception instanceof UnauthorizedException) {
            return new CassandraUnauthorizedException(message, exception);
        }
        if (exception instanceof AllNodesFailedException) {
            return new CassandraConnectionFailureException(((AllNodesFailedException)exception).getErrors(), message, exception);
        }
        String exceptionType = ClassUtils.getShortName((Class)ClassUtils.getUserClass(exception.getClass()));
        if (CONNECTION_FAILURE_TYPES.contains(exceptionType)) {
            Map<Node, Throwable> errorMap = Collections.emptyMap();
            if (exception instanceof CoordinatorException) {
                CoordinatorException cx = (CoordinatorException)exception;
                errorMap = Collections.singletonMap(cx.getCoordinator(), exception);
            }
            return new CassandraConnectionFailureException(errorMap, message, exception);
        }
        if (RESOURCE_FAILURE_TYPES.contains(exceptionType)) {
            return new DataAccessResourceFailureException(message, (Throwable)exception);
        }
        if (exception instanceof DriverException || exception.getClass().getName().startsWith("com.datastax.oss.driver")) {
            return new CassandraUncategorizedException(message, exception);
        }
        return null;
    }

    protected String buildMessage(@Nullable String task, @Nullable String cql, RuntimeException ex) {
        if (StringUtils.hasText((String)task) || StringUtils.hasText((String)cql)) {
            return task + "; CQL [" + cql + "]; " + ex.getMessage();
        }
        return ex.getMessage();
    }
}

