/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.init;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.data.cassandra.core.cql.session.init.ScriptException;

public class CompositeKeyspacePopulator
implements KeyspacePopulator {
    private final List<KeyspacePopulator> populators = new ArrayList<KeyspacePopulator>(4);

    public CompositeKeyspacePopulator() {
    }

    public CompositeKeyspacePopulator(Collection<KeyspacePopulator> populators) {
        this.populators.addAll(populators);
    }

    public CompositeKeyspacePopulator(KeyspacePopulator ... populators) {
        this.populators.addAll(Arrays.asList(populators));
    }

    public void setPopulators(KeyspacePopulator ... populators) {
        this.populators.clear();
        this.populators.addAll(Arrays.asList(populators));
    }

    public void addPopulators(KeyspacePopulator ... populators) {
        this.populators.addAll(Arrays.asList(populators));
    }

    @Override
    public void populate(CqlSession session) throws ScriptException {
        for (KeyspacePopulator populator : this.populators) {
            populator.populate(session);
        }
    }
}

