/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.SetType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.ColumnType;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    public UpdateMapper(CassandraConverter converter) {
        super(converter);
    }

    public Update getMappedObject(Update update, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Collection<Update.AssignmentOp> assignmentOperations = update.getUpdateOperations();
        ArrayList<Update.AssignmentOp> mapped = new ArrayList<Update.AssignmentOp>(assignmentOperations.size());
        for (Update.AssignmentOp assignmentOp : assignmentOperations) {
            QueryMapper.Field field = this.createPropertyField(entity, assignmentOp.getColumnName());
            field.getProperty().filter(it -> it.getOrdinal() != null).ifPresent(it -> {
                throw new IllegalArgumentException(String.format("Cannot reference tuple value elements, property [%s]", field.getMappedKey()));
            });
            mapped.add(this.getMappedUpdateOperation(assignmentOp, field));
        }
        return Update.of(mapped);
    }

    private Update.AssignmentOp getMappedUpdateOperation(Update.AssignmentOp assignmentOp, QueryMapper.Field field) {
        if (assignmentOp instanceof Update.SetOp) {
            return this.getMappedUpdateOperation(field, (Update.SetOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.RemoveOp) {
            return this.getMappedUpdateOperation(field, (Update.RemoveOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.IncrOp) {
            return new Update.IncrOp(field.getMappedKey(), ((Update.IncrOp)assignmentOp).getValue());
        }
        if (assignmentOp instanceof Update.AddToOp) {
            return this.getMappedUpdateOperation(field, (Update.AddToOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.AddToMapOp) {
            return this.getMappedUpdateOperation(field, (Update.AddToMapOp)assignmentOp);
        }
        throw new IllegalArgumentException(String.format("UpdateOp [%s] not supported", assignmentOp));
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.SetOp updateOp) {
        Collection collection;
        Object rawValue = updateOp.getValue();
        if (updateOp instanceof Update.SetAtKeyOp) {
            Update.SetAtKeyOp op = (Update.SetAtKeyOp)updateOp;
            Assert.state((op.getValue() != null ? 1 : 0) != 0, () -> String.format("SetAtKeyOp for %s attempts to set null", field.getProperty()));
            Optional<TypeInformation> typeInformation = field.getProperty().map(PersistentProperty::getTypeInformation);
            Optional<TypeInformation> keyType = typeInformation.map(TypeInformation::getComponentType);
            Optional<TypeInformation> valueType = typeInformation.map(TypeInformation::getMapValueType);
            Object mappedKey = keyType.map(typeInfo -> this.getConverter().convertToColumnType(op.getKey(), (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(op.getKey()));
            Object mappedValue = valueType.map(typeInfo -> this.getConverter().convertToColumnType(op.getValue(), (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(op.getValue()));
            return new Update.SetAtKeyOp(field.getMappedKey(), mappedKey, mappedValue);
        }
        ColumnType descriptor = this.getColumnType(field, rawValue, updateOp instanceof Update.SetAtIndexOp ? QueryMapper.ColumnTypeTransformer.COLLECTION_COMPONENT_TYPE : QueryMapper.ColumnTypeTransformer.AS_IS);
        if (updateOp instanceof Update.SetAtIndexOp) {
            Update.SetAtIndexOp op = (Update.SetAtIndexOp)updateOp;
            Assert.state((op.getValue() != null ? 1 : 0) != 0, () -> String.format("SetAtIndexOp for %s attempts to set null", field.getProperty()));
            Object mappedValue = this.getConverter().convertToColumnType(op.getValue(), descriptor);
            return new Update.SetAtIndexOp(field.getMappedKey(), op.getIndex(), mappedValue);
        }
        if (rawValue instanceof Collection && descriptor.isCollectionLike() && (collection = (Collection)rawValue).isEmpty()) {
            int protocolCode = field.getProperty().map(property -> this.getConverter().getColumnTypeResolver().resolve((CassandraPersistentProperty)property).getDataType()).map(DataType::getProtocolCode).orElse(32);
            if (protocolCode == 34) {
                return new Update.SetOp(field.getMappedKey(), Collections.emptySet());
            }
            return new Update.SetOp(field.getMappedKey(), Collections.emptyList());
        }
        Object mappedValue = rawValue == null ? null : this.getConverter().convertToColumnType(rawValue, descriptor);
        return new Update.SetOp(field.getMappedKey(), mappedValue);
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.RemoveOp updateOp) {
        Object value = updateOp.getValue();
        ColumnType descriptor = this.getColumnType(field, value, QueryMapper.ColumnTypeTransformer.AS_IS);
        boolean mapLike = false;
        if (field.getProperty().isPresent() && field.getProperty().get().isMapLike()) {
            descriptor = this.getColumnType(field, value, value instanceof Collection ? QueryMapper.ColumnTypeTransformer.ENCLOSING_MAP_KEY_SET : QueryMapper.ColumnTypeTransformer.MAP_KEY_TYPE);
            mapLike = true;
        }
        Set<Object> mappedValue = this.getConverter().convertToColumnType(value, descriptor);
        if (mapLike && !(mappedValue instanceof Collection)) {
            mappedValue = Collections.singleton(mappedValue);
        }
        return new Update.RemoveOp(field.getMappedKey(), mappedValue);
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.AddToOp updateOp) {
        Iterable<Object> value = updateOp.getValue();
        ColumnType descriptor = this.getColumnType(field, value, QueryMapper.ColumnTypeTransformer.AS_IS);
        AbstractCollection mappedValue = (AbstractCollection)this.getConverter().convertToColumnType(value, descriptor);
        if (field.getProperty().isPresent()) {
            AbstractCollection collection;
            DataType dataType = this.getConverter().getColumnTypeResolver().resolve(field.getProperty().get()).getDataType();
            if (dataType instanceof SetType && !(mappedValue instanceof Set)) {
                collection = new HashSet();
                collection.addAll(mappedValue);
                mappedValue = collection;
            }
            if (dataType instanceof ListType && !(mappedValue instanceof List)) {
                collection = new ArrayList();
                collection.addAll(mappedValue);
                mappedValue = collection;
            }
        }
        return new Update.AddToOp(field.getMappedKey(), mappedValue, updateOp.getMode());
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.AddToMapOp updateOp) {
        Optional<TypeInformation> typeInformation = field.getProperty().map(PersistentProperty::getTypeInformation);
        Optional<TypeInformation> keyType = typeInformation.map(TypeInformation::getComponentType);
        Optional<TypeInformation> valueType = typeInformation.map(TypeInformation::getMapValueType);
        LinkedHashMap result = new LinkedHashMap(updateOp.getValue().size(), 1.0f);
        updateOp.getValue().forEach((key, value) -> {
            Object mappedKey = keyType.map(typeInfo -> this.getConverter().convertToColumnType(key, (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(key));
            Object mappedValue = valueType.map(typeInfo -> this.getConverter().convertToColumnType(value, (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(value));
            result.put(mappedKey, mappedValue);
        });
        return new Update.AddToMapOp(field.getMappedKey(), result);
    }
}

