/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.ExecutableUpdateOperation;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ExecutableUpdateOperationSupport
implements ExecutableUpdateOperation {
    private final CassandraTemplate template;

    public ExecutableUpdateOperationSupport(CassandraTemplate template) {
        this.template = template;
    }

    @Override
    public ExecutableUpdateOperation.ExecutableUpdate update(Class<?> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableUpdateSupport(this.template, domainType, Query.empty(), null);
    }

    static class ExecutableUpdateSupport
    implements ExecutableUpdateOperation.ExecutableUpdate,
    ExecutableUpdateOperation.TerminatingUpdate {
        private final CassandraTemplate template;
        private final Class<?> domainType;
        private final Query query;
        @Nullable
        private final CqlIdentifier tableName;

        public ExecutableUpdateSupport(CassandraTemplate template, Class<?> domainType, Query query2, CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public ExecutableUpdateOperation.UpdateWithQuery inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ExecutableUpdateSupport(this.template, this.domainType, this.query, tableName);
        }

        @Override
        public ExecutableUpdateOperation.TerminatingUpdate matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ExecutableUpdateSupport(this.template, this.domainType, query2, this.tableName);
        }

        @Override
        public WriteResult apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return this.template.doUpdate(this.query, update, this.domainType, this.getTableName());
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }
}

