/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface CriteriaDefinition {
    public ColumnName getColumnName();

    public Predicate getPredicate();

    public static enum Operators implements Operator
    {
        CONTAINS("CONTAINS"),
        CONTAINS_KEY("CONTAINS KEY"),
        EQ("="),
        NE("!="),
        IS_NOT_NULL("IS NOT NULL"){

            @Override
            public String toCql(@Nullable Object value) {
                return this.toString();
            }
        }
        ,
        GT(">"),
        GTE(">="),
        LT("<"),
        LTE("<="),
        IN("IN"),
        LIKE("LIKE");

        private final String operator;

        public static Optional<Operators> from(String operator) {
            for (Operators operatorsValue : Operators.values()) {
                if (!operatorsValue.toString().equals(operator)) continue;
                return Optional.of(operatorsValue);
            }
            return Optional.empty();
        }

        private Operators(String operator) {
            this.operator = operator;
        }

        @Override
        public String toString() {
            return this.operator;
        }
    }

    public static interface Operator {
        public String toString();

        default public String toCql(@Nullable Object value) {
            return String.format("%s %s", this.toString(), value);
        }
    }

    public static class Predicate {
        private final Operator operator;
        @Nullable
        private final Object value;

        public Predicate(Operator operator, @Nullable Object value) {
            Assert.notNull((Object)operator, (String)"Operator must not be null");
            this.operator = operator;
            this.value = value;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public <R> R as(Function<Object, ? extends R> mappingFunction) {
            return mappingFunction.apply(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Predicate)) {
                return false;
            }
            Predicate predicate = (Predicate)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.operator, (Object)predicate.operator)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.value, (Object)predicate.value);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.operator);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.value);
            return result;
        }
    }
}

