/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.Statement;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveResultSet;
import org.springframework.data.cassandra.core.DeleteOptions;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.ReactiveCassandraBatchOperations;
import org.springframework.data.cassandra.core.ReactiveFluentCassandraOperations;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.domain.Slice;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveCassandraOperations
extends ReactiveFluentCassandraOperations {
    public ReactiveCassandraBatchOperations batchOps();

    public ReactiveCqlOperations getReactiveCqlOperations();

    public CassandraConverter getConverter();

    public <T> Flux<T> select(String var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<T> selectOne(String var1, Class<T> var2) throws DataAccessException;

    public <T> Flux<T> select(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<Slice<T>> slice(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<T> selectOne(Statement<?> var1, Class<T> var2) throws DataAccessException;

    public Mono<ReactiveResultSet> execute(Statement<?> var1) throws DataAccessException;

    public <T> Flux<T> select(Query var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<Slice<T>> slice(Query var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<T> selectOne(Query var1, Class<T> var2) throws DataAccessException;

    public Mono<Boolean> update(Query var1, Update var2, Class<?> var3) throws DataAccessException;

    public Mono<Boolean> delete(Query var1, Class<?> var2) throws DataAccessException;

    public Mono<Long> count(Class<?> var1) throws DataAccessException;

    public Mono<Long> count(Query var1, Class<?> var2) throws DataAccessException;

    public Mono<Boolean> exists(Object var1, Class<?> var2) throws DataAccessException;

    public Mono<Boolean> exists(Query var1, Class<?> var2) throws DataAccessException;

    public <T> Mono<T> selectOneById(Object var1, Class<T> var2) throws DataAccessException;

    public <T> Mono<T> insert(T var1) throws DataAccessException;

    public <T> Mono<EntityWriteResult<T>> insert(T var1, InsertOptions var2) throws DataAccessException;

    public <T> Mono<T> update(T var1) throws DataAccessException;

    public <T> Mono<EntityWriteResult<T>> update(T var1, UpdateOptions var2) throws DataAccessException;

    public <T> Mono<T> delete(T var1) throws DataAccessException;

    public Mono<WriteResult> delete(Object var1, QueryOptions var2) throws DataAccessException;

    default public Mono<WriteResult> delete(Object entity, DeleteOptions options) throws DataAccessException {
        return this.delete(entity, (QueryOptions)options);
    }

    public Mono<Boolean> deleteById(Object var1, Class<?> var2) throws DataAccessException;

    public Mono<Void> truncate(Class<?> var1) throws DataAccessException;
}

