/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.AbstractReactiveCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveStringBasedCassandraQuery
extends AbstractReactiveCassandraQuery {
    private static final String COUNT_AND_EXISTS = "Manually defined query for %s cannot be a count and exists query at the same time!";
    private final StringBasedQuery stringBasedQuery;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;

    public ReactiveStringBasedCassandraQuery(ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public ReactiveStringBasedCassandraQuery(String query2, ReactiveCassandraQueryMethod method, ReactiveCassandraOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations);
        Assert.hasText((String)query2, (String)"Query must not be empty");
        this.stringBasedQuery = new StringBasedQuery(query2, new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider));
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation().orElse(null);
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            if (ProjectionUtil.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_AND_EXISTS, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
        }
    }

    protected StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    @Override
    public SimpleStatement createQuery(CassandraParameterAccessor parameterAccessor) {
        return this.getQueryStatementCreator().select(this.getStringBasedQuery(), parameterAccessor);
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    @Override
    protected boolean isModifyingQuery() {
        return false;
    }
}

