/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class RowReader {
    private final Row row;
    private final CodecRegistry codecRegistry;
    private final ColumnDefinitions columns;

    public RowReader(Row row) {
        this.row = row;
        this.codecRegistry = row.codecRegistry();
        this.columns = row.getColumnDefinitions();
    }

    @Nullable
    public Object get(CqlIdentifier columnName) {
        return this.get(columnName.toString());
    }

    @Nullable
    public Object get(String columnName) {
        return this.get(this.getColumnIndex(columnName));
    }

    @Nullable
    public Object get(int columnIndex) {
        if (this.row.isNull(columnIndex)) {
            return null;
        }
        ColumnDefinition type = this.columns.get(columnIndex);
        if (type.getType() instanceof ListType || type.getType() instanceof SetType || type.getType() instanceof MapType) {
            return this.getCollection(columnIndex, type.getType());
        }
        if (type instanceof TupleType) {
            return this.row.getTupleValue(columnIndex);
        }
        if (type instanceof UserDefinedType) {
            return this.row.getUdtValue(columnIndex);
        }
        return this.row.getObject(columnIndex);
    }

    @Nullable
    public <T> T get(CqlIdentifier columnName, Class<T> requestedType) {
        return this.get(columnName.toString(), requestedType);
    }

    @Nullable
    public <T> T get(String columnName, Class<T> requestedType) {
        return this.get(this.getColumnIndex(columnName), requestedType);
    }

    @Nullable
    public <T> T get(int columnIndex, Class<T> requestedType) {
        Object value = this.get(columnIndex);
        return requestedType.cast(value);
    }

    @Nullable
    private Object getCollection(int index, DataType type) {
        if (type instanceof ListType) {
            ListType listType = (ListType)type;
            DataType valueType = listType.getElementType();
            TypeCodec typeCodec = this.codecRegistry.codecFor(valueType);
            return this.row.getList(index, typeCodec.getJavaType().getRawType());
        }
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            DataType valueType = setType.getElementType();
            TypeCodec typeCodec = this.codecRegistry.codecFor(valueType);
            return this.row.getSet(index, typeCodec.getJavaType().getRawType());
        }
        if (type instanceof MapType) {
            return this.row.getObject(index);
        }
        throw new IllegalStateException("Unknown Collection type encountered; valid collections are List, Set and Map.");
    }

    private int getColumnIndex(String columnName) {
        int index = this.columns.firstIndexOf(columnName);
        Assert.isTrue((index > -1 ? 1 : 0) != 0, (String)String.format("Column [%s] does not exist in table", columnName));
        return index;
    }

    public Row getRow() {
        return this.row;
    }

    public boolean contains(CqlIdentifier columnName) {
        return this.row.getColumnDefinitions().contains(columnName);
    }
}

