/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.springframework.data.cassandra.core.cql.ExecutionProfileResolver;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.lang.Nullable;

public class InsertOptions
extends WriteOptions {
    private static final InsertOptions EMPTY = new InsertOptionsBuilder().build();
    private boolean ifNotExists;
    private boolean insertNulls;

    private InsertOptions(@Nullable ConsistencyLevel consistencyLevel, ExecutionProfileResolver executionProfileResolver, @Nullable Integer pageSize, @Nullable ConsistencyLevel serialConsistencyLevel, Duration timeout, Duration ttl, @Nullable Long timestamp, @Nullable Boolean tracing, boolean ifNotExists, boolean insertNulls) {
        super(consistencyLevel, executionProfileResolver, pageSize, serialConsistencyLevel, timeout, ttl, timestamp, tracing);
        this.ifNotExists = ifNotExists;
        this.insertNulls = insertNulls;
    }

    public static InsertOptionsBuilder builder() {
        return new InsertOptionsBuilder();
    }

    public static InsertOptions empty() {
        return EMPTY;
    }

    @Override
    public InsertOptionsBuilder mutate() {
        return new InsertOptionsBuilder(this);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isInsertNulls() {
        return this.insertNulls;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsertOptions)) {
            return false;
        }
        InsertOptions other = (InsertOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIfNotExists() != other.isIfNotExists()) {
            return false;
        }
        return this.isInsertNulls() == other.isInsertNulls();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InsertOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIfNotExists() ? 79 : 97);
        result = result * 59 + (this.isInsertNulls() ? 79 : 97);
        return result;
    }

    public static class InsertOptionsBuilder
    extends WriteOptions.WriteOptionsBuilder {
        private boolean ifNotExists;
        private boolean insertNulls;

        private InsertOptionsBuilder() {
        }

        private InsertOptionsBuilder(InsertOptions insertOptions) {
            super(insertOptions);
            this.ifNotExists = insertOptions.ifNotExists;
            this.insertNulls = insertOptions.insertNulls;
        }

        @Override
        public InsertOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            super.consistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public InsertOptionsBuilder executionProfile(String profileName) {
            super.executionProfile(profileName);
            return this;
        }

        @Override
        public InsertOptionsBuilder executionProfile(ExecutionProfileResolver executionProfileResolver) {
            super.executionProfile(executionProfileResolver);
            return this;
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder fetchSize(int fetchSize) {
            return (InsertOptionsBuilder)super.fetchSize(fetchSize);
        }

        @Override
        public InsertOptionsBuilder pageSize(int pageSize) {
            return (InsertOptionsBuilder)super.pageSize(pageSize);
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder readTimeout(long readTimeout) {
            super.readTimeout(readTimeout);
            return this;
        }

        @Override
        @Deprecated
        public InsertOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            super.readTimeout(readTimeout, timeUnit);
            return this;
        }

        @Override
        public InsertOptionsBuilder serialConsistencyLevel(ConsistencyLevel consistencyLevel) {
            super.serialConsistencyLevel(consistencyLevel);
            return this;
        }

        @Override
        public InsertOptionsBuilder timeout(Duration timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public InsertOptionsBuilder ttl(Duration ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public InsertOptionsBuilder tracing(boolean tracing) {
            super.tracing(tracing);
            return this;
        }

        @Override
        public InsertOptionsBuilder withTracing() {
            super.withTracing();
            return this;
        }

        @Override
        public InsertOptionsBuilder ttl(int ttl) {
            super.ttl(ttl);
            return this;
        }

        @Override
        public InsertOptionsBuilder timestamp(long timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        @Override
        public InsertOptionsBuilder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this;
        }

        public InsertOptionsBuilder withIfNotExists() {
            return this.ifNotExists(true);
        }

        public InsertOptionsBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        public InsertOptionsBuilder withInsertNulls() {
            return this.withInsertNulls(true);
        }

        public InsertOptionsBuilder withInsertNulls(boolean insertNulls) {
            this.insertNulls = insertNulls;
            return this;
        }

        @Override
        public InsertOptions build() {
            return new InsertOptions(this.consistencyLevel, this.executionProfileResolver, this.pageSize, this.serialConsistencyLevel, this.timeout, this.ttl, this.timestamp, this.tracing, this.ifNotExists, this.insertNulls);
        }
    }
}

