/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.HostMapper;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCallback;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.ResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RingMember;
import org.springframework.data.cassandra.core.cql.RingMemberHostMapper;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.SimplePreparedStatementCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CqlTemplate
extends CassandraAccessor
implements CqlOperations {
    public CqlTemplate() {
    }

    public CqlTemplate(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSession(session);
    }

    public CqlTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public <T> T execute(SessionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            return action.doInSession(this.getCurrentSession());
        }
        catch (DriverException e) {
            throw this.translateException("SessionCallback", CqlTemplate.toCql(action), e);
        }
    }

    @Override
    public boolean execute(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.queryForResultSet(cql).wasApplied();
    }

    @Override
    @Nullable
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)cql);
            }
            SimpleStatement statement = this.applyStatementSettings(new SimpleStatement(cql));
            ResultSet results = this.getCurrentSession().execute((Statement)statement);
            return resultSetExtractor.extractData(results);
        }
        catch (DriverException e) {
            throw this.translateException("Query", cql, e);
        }
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(cql, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(cql, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(String cql) throws DataAccessException {
        return (List)((Object)this.query(cql, this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType) throws DataAccessException {
        return (List)this.query(cql, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(String cql) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(cql, this.newResultSetExtractor(rowMapper))));
    }

    @Override
    public ResultSet queryForResultSet(String cql) throws DataAccessException {
        return this.query(cql, (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(String cql) throws DataAccessException {
        return () -> this.queryForResultSet(cql).iterator();
    }

    @Override
    public boolean execute(Statement statement) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        return this.queryForResultSet(statement).wasApplied();
    }

    @Override
    public <T> T query(Statement statement, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)statement);
            }
            return resultSetExtractor.extractData(this.getCurrentSession().execute(this.applyStatementSettings(statement)));
        }
        catch (DriverException e) {
            throw this.translateException("Query", statement.toString(), e);
        }
    }

    @Override
    public void query(Statement statement, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(statement, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(statement, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(Statement statement) throws DataAccessException {
        return (List)((Object)this.query(statement, this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(Statement statement, Class<T> elementType) throws DataAccessException {
        return (List)this.query(statement, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(Statement statement) throws DataAccessException {
        return this.queryForObject(statement, this.newColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(Statement statement, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(statement, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(statement, this.newResultSetExtractor(rowMapper))));
    }

    @Override
    public ResultSet queryForResultSet(Statement statement) throws DataAccessException {
        return this.query(statement, (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(Statement statement) throws DataAccessException {
        return () -> this.queryForResultSet(statement).iterator();
    }

    @Override
    public boolean execute(String cql, Object ... args) throws DataAccessException {
        return this.execute(cql, this.newPreparedStatementBinder(args));
    }

    @Override
    public boolean execute(String cql, @Nullable PreparedStatementBinder psb) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), psb, ResultSet::wasApplied);
    }

    @Override
    @Nullable
    public <T> T execute(String cql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.newPreparedStatementCreator(cql), action);
    }

    @Override
    public boolean execute(PreparedStatementCreator preparedStatementCreator) throws DataAccessException {
        return this.query(preparedStatementCreator, ResultSet::wasApplied);
    }

    @Override
    @Nullable
    public <T> T execute(PreparedStatementCreator preparedStatementCreator, PreparedStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"PreparedStatementCallback object must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)CqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            Session session = this.getCurrentSession();
            return action.doInPreparedStatement(session, this.applyStatementSettings(preparedStatementCreator.createPreparedStatement(session)));
        }
        catch (DriverException e) {
            throw this.translateException("PreparedStatementCallback", CqlTemplate.toCql(preparedStatementCreator), e);
        }
    }

    @Override
    public <T> T query(PreparedStatementCreator preparedStatementCreator, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(preparedStatementCreator, null, resultSetExtractor);
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowMapper));
    }

    @Override
    @Nullable
    public <T> T query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor object must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)CqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            Session session = this.getCurrentSession();
            PreparedStatement preparedStatement = preparedStatementCreator.createPreparedStatement(session);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing prepared statement [{}]", (Object)preparedStatement);
            }
            BoundStatement boundStatement = this.applyStatementSettings(psb != null ? psb.bindValues(preparedStatement) : preparedStatement.bind());
            ResultSet results = session.execute((Statement)boundStatement);
            return resultSetExtractor.extractData(results);
        }
        catch (DriverException e) {
            throw this.translateException("Query", CqlTemplate.toCql(preparedStatementCreator), e);
        }
    }

    @Override
    public void query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> T query(String cql, ResultSetExtractor<T> resultSetExtractor, Object ... args) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), resultSetExtractor);
    }

    @Override
    public void query(String cql, RowCallbackHandler rowCallbackHandler, Object ... args) throws DataAccessException {
        this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> T query(String cql, @Nullable PreparedStatementBinder psb, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), psb, resultSetExtractor);
    }

    @Override
    public void query(String cql, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        this.query(this.newPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowCallbackHandler));
    }

    @Override
    public <T> List<T> query(String cql, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public List<Map<String, Object>> queryForList(String cql, Object ... args) throws DataAccessException {
        return (List)((Object)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newColumnMapRowMapper())));
    }

    @Override
    public <T> List<T> queryForList(String cql, Class<T> elementType, Object ... args) throws DataAccessException {
        return (List)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public Map<String, Object> queryForMap(String cql, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper(), args);
    }

    @Override
    public <T> T queryForObject(String cql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType), args);
    }

    @Override
    public <T> T queryForObject(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return (T)DataAccessUtils.requiredSingleResult((Collection)((Collection)this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper, 1))));
    }

    @Override
    public ResultSet queryForResultSet(String cql, Object ... args) throws DataAccessException {
        return this.query(this.newPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), (ResultSet rs) -> rs);
    }

    @Override
    public Iterable<Row> queryForRows(String cql, Object ... args) throws DataAccessException {
        return () -> this.queryForResultSet(cql, args).iterator();
    }

    @Override
    public List<RingMember> describeRing() throws DataAccessException {
        return (List)this.describeRing(RingMemberHostMapper.INSTANCE);
    }

    @Override
    public <T> Collection<T> describeRing(HostMapper<T> hostMapper) throws DataAccessException {
        Assert.notNull(hostMapper, (String)"HostMapper must not be null");
        return hostMapper.mapHosts(this.getHosts());
    }

    private Set<Host> getHosts() {
        return this.getCurrentSession().getCluster().getMetadata().getAllHosts();
    }

    protected PreparedStatementCreator newPreparedStatementCreator(String cql) {
        return new SimplePreparedStatementCreator(cql);
    }

    protected DataAccessException translateException(String task, @Nullable String cql, DriverException driverException) {
        return this.translate(task, cql, driverException);
    }

    private Session getCurrentSession() {
        SessionFactory sessionFactory = this.getSessionFactory();
        Assert.state((sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory is null");
        return sessionFactory.getSession();
    }
}

