/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.DataType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    public UpdateMapper(CassandraConverter converter) {
        super(converter);
    }

    public Update getMappedObject(Update update, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        Collection<Update.AssignmentOp> assignmentOperations = update.getUpdateOperations();
        ArrayList<Update.AssignmentOp> mapped = new ArrayList<Update.AssignmentOp>(assignmentOperations.size());
        for (Update.AssignmentOp assignmentOp : assignmentOperations) {
            QueryMapper.Field field = this.createPropertyField(entity, assignmentOp.getColumnName());
            field.getProperty().filter(it -> it.getOrdinal() != null).ifPresent(it -> {
                throw new IllegalArgumentException(String.format("Cannot reference tuple value elements, property [%s]", field.getMappedKey()));
            });
            mapped.add(this.getMappedUpdateOperation(assignmentOp, field));
        }
        return Update.of(mapped);
    }

    private Update.AssignmentOp getMappedUpdateOperation(Update.AssignmentOp assignmentOp, QueryMapper.Field field) {
        if (assignmentOp instanceof Update.SetOp) {
            return this.getMappedUpdateOperation(field, (Update.SetOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.RemoveOp) {
            return this.getMappedUpdateOperation(field, (Update.RemoveOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.IncrOp) {
            return new Update.IncrOp(field.getMappedKey(), ((Update.IncrOp)assignmentOp).getValue());
        }
        if (assignmentOp instanceof Update.AddToOp) {
            return this.getMappedUpdateOperation(field, (Update.AddToOp)assignmentOp);
        }
        if (assignmentOp instanceof Update.AddToMapOp) {
            return this.getMappedUpdateOperation(field, (Update.AddToMapOp)assignmentOp);
        }
        throw new IllegalArgumentException(String.format("UpdateOp [%s] not supported", assignmentOp));
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.SetOp updateOp) {
        Collection collection;
        Object rawValue = updateOp.getValue();
        if (updateOp instanceof Update.SetAtKeyOp) {
            Update.SetAtKeyOp op = (Update.SetAtKeyOp)updateOp;
            Assert.state((op.getValue() != null ? 1 : 0) != 0, () -> String.format("SetAtKeyOp for %s attempts to set null", field.getProperty()));
            Optional<TypeInformation> typeInformation = field.getProperty().map(PersistentProperty::getTypeInformation);
            Optional<TypeInformation> keyType = typeInformation.map(TypeInformation::getComponentType);
            Optional<TypeInformation> valueType = typeInformation.map(TypeInformation::getMapValueType);
            Object mappedKey = keyType.map(typeInfo -> this.getConverter().convertToColumnType(op.getKey(), (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(op.getKey()));
            Object mappedValue = valueType.map(typeInfo -> this.getConverter().convertToColumnType(op.getValue(), (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(op.getValue()));
            return new Update.SetAtKeyOp(field.getMappedKey(), mappedKey, mappedValue);
        }
        TypeInformation<?> typeInformation = this.getTypeInformation(field, rawValue);
        if (updateOp instanceof Update.SetAtIndexOp) {
            Update.SetAtIndexOp op = (Update.SetAtIndexOp)updateOp;
            Assert.state((op.getValue() != null ? 1 : 0) != 0, () -> String.format("SetAtIndexOp for %s attempts to set null", field.getProperty()));
            Object mappedValue = this.getConverter().convertToColumnType(op.getValue(), typeInformation);
            return new Update.SetAtIndexOp(field.getMappedKey(), op.getIndex(), mappedValue);
        }
        if (rawValue instanceof Collection && typeInformation.isCollectionLike() && (collection = (Collection)rawValue).isEmpty()) {
            DataType.Name dataType = field.getProperty().map(property -> this.getMappingContext().getDataType((CassandraPersistentProperty)property)).map(DataType::getName).orElse(DataType.Name.LIST);
            if (dataType == DataType.Name.SET) {
                return new Update.SetOp(field.getMappedKey(), Collections.emptySet());
            }
            return new Update.SetOp(field.getMappedKey(), Collections.emptyList());
        }
        Object mappedValue = rawValue == null ? null : this.getConverter().convertToColumnType(rawValue, typeInformation);
        return new Update.SetOp(field.getMappedKey(), mappedValue);
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.RemoveOp updateOp) {
        Object value = updateOp.getValue();
        TypeInformation<?> typeInformation = this.getTypeInformation(field, value);
        Object mappedValue = this.getConverter().convertToColumnType(value, typeInformation);
        return new Update.RemoveOp(field.getMappedKey(), mappedValue);
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.AddToOp updateOp) {
        Iterable<Object> value = updateOp.getValue();
        TypeInformation<?> typeInformation = this.getTypeInformation(field, value);
        AbstractCollection mappedValue = (AbstractCollection)this.getConverter().convertToColumnType(value, typeInformation);
        if (field.getProperty().isPresent()) {
            AbstractCollection collection;
            DataType dataType = this.getMappingContext().getDataType(field.getProperty().get());
            if (dataType.getName() == DataType.Name.SET && !(mappedValue instanceof Set)) {
                collection = new HashSet();
                collection.addAll(mappedValue);
                mappedValue = collection;
            }
            if (dataType.getName() == DataType.Name.LIST && !(mappedValue instanceof List)) {
                collection = new ArrayList();
                collection.addAll(mappedValue);
                mappedValue = collection;
            }
        }
        return new Update.AddToOp(field.getMappedKey(), mappedValue, updateOp.getMode());
    }

    private Update.AssignmentOp getMappedUpdateOperation(QueryMapper.Field field, Update.AddToMapOp updateOp) {
        Optional<TypeInformation> typeInformation = field.getProperty().map(PersistentProperty::getTypeInformation);
        Optional<TypeInformation> keyType = typeInformation.map(TypeInformation::getComponentType);
        Optional<TypeInformation> valueType = typeInformation.map(TypeInformation::getMapValueType);
        LinkedHashMap result = new LinkedHashMap(updateOp.getValue().size(), 1.0f);
        updateOp.getValue().forEach((key, value) -> {
            Object mappedKey = keyType.map(typeInfo -> this.getConverter().convertToColumnType(key, (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(key));
            Object mappedValue = valueType.map(typeInfo -> this.getConverter().convertToColumnType(value, (TypeInformation<?>)typeInfo)).orElseGet(() -> this.getConverter().convertToColumnType(value));
            result.put(mappedKey, mappedValue);
        });
        return new Update.AddToMapOp(field.getMappedKey(), result);
    }
}

