/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

final class ProjectionUtil {
    private static final Set<DataType> NUMERIC_TYPES = new HashSet<DataType>(Arrays.asList(DataType.bigint(), DataType.varint(), DataType.smallint(), DataType.cint(), DataType.counter(), DataType.tinyint()));

    static boolean hasAmbiguousProjectionFlags(Boolean ... flags) {
        return Arrays.stream(flags).filter(Boolean::booleanValue).count() > 1L;
    }

    static boolean qualifiesAsCountProjection(Row row) {
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        return columnDefinitions.size() == 1 && NUMERIC_TYPES.contains(columnDefinitions.getType(0));
    }

    private ProjectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

