/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncPreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.ExceptionTranslatingListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.GuavaListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCallback;
import org.springframework.data.cassandra.core.cql.ResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RowCallbackHandler;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;
import org.springframework.util.concurrent.SettableListenableFuture;

public class AsyncCqlTemplate
extends CassandraAccessor
implements AsyncCqlOperations {
    public AsyncCqlTemplate() {
    }

    public AsyncCqlTemplate(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.setSession(session);
    }

    public AsyncCqlTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"SessionFactory must not be null");
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public <T> ListenableFuture<T> execute(AsyncSessionCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            return action.doInSession(this.getCurrentSession());
        }
        catch (DriverException e) {
            throw this.translateException("SessionCallback", AsyncCqlTemplate.toCql(action), e);
        }
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return new MappingListenableFutureAdapter(this.queryForResultSet(cql), ResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)cql);
            }
            SimpleStatement simpleStatement = this.applyStatementSettings(new SimpleStatement(cql));
            ResultSetFuture results = this.getCurrentSession().executeAsync((Statement)simpleStatement);
            return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(new GuavaListenableFutureAdapter(results, ex -> this.translateExceptionIfPossible("Query", cql, ex)), resultSetExtractor::extractData), this.getExceptionTranslator());
        }
        catch (DriverException e) {
            throw this.translateException("Query", cql, e);
        }
    }

    @Override
    public ListenableFuture<Void> query(String cql, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Object> results = this.query(cql, this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(cql, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(String cql) throws DataAccessException {
        return this.query(cql, this.newResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(String cql, Class<T> elementType) throws DataAccessException {
        return this.query(cql, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(String cql) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper());
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, RowMapper<T> rowMapper) throws DataAccessException {
        ListenableFuture<T> results = this.query(cql, this.newResultSetExtractor(rowMapper));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<ResultSet> queryForResultSet(String cql) throws DataAccessException {
        return this.query(cql, (ResultSet rs) -> rs);
    }

    @Override
    public ListenableFuture<Boolean> execute(Statement statement) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        return new MappingListenableFutureAdapter(this.queryForResultSet(statement), ResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> query(Statement statement, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"CQL Statement must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor must not be null");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing CQL Statement [{}]", (Object)statement);
            }
            ResultSetFuture results = this.getCurrentSession().executeAsync(this.applyStatementSettings(statement));
            return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(new GuavaListenableFutureAdapter(results, ex -> this.translateExceptionIfPossible("Query", statement.toString(), ex)), resultSetExtractor::extractData), this.getExceptionTranslator());
        }
        catch (DriverException e) {
            throw this.translateException("Query", statement.toString(), e);
        }
    }

    @Override
    public ListenableFuture<Void> query(Statement statement, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Object> result = this.query(statement, this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(result, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(statement, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(Statement statement) throws DataAccessException {
        return this.query(statement, this.newResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(Statement statement, Class<T> elementType) throws DataAccessException {
        return this.query(statement, this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(Statement statement) throws DataAccessException {
        return this.queryForObject(statement, this.newColumnMapRowMapper());
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(Statement statement, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(statement, this.newSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(Statement statement, RowMapper<T> rowMapper) throws DataAccessException {
        ListenableFuture<T> results = this.query(statement, this.newResultSetExtractor(rowMapper));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<ResultSet> queryForResultSet(Statement statement) throws DataAccessException {
        return this.query(statement, (ResultSet rs) -> rs);
    }

    @Override
    public ListenableFuture<Boolean> execute(AsyncPreparedStatementCreator preparedStatementCreator) throws DataAccessException {
        return this.query(preparedStatementCreator, ResultSet::wasApplied);
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql, Object ... args) throws DataAccessException {
        return this.execute(cql, this.newPreparedStatementBinder(args));
    }

    @Override
    public ListenableFuture<Boolean> execute(String cql, @Nullable PreparedStatementBinder psb) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), psb, ResultSet::wasApplied);
    }

    @Override
    public <T> ListenableFuture<T> execute(String cql, PreparedStatementCallback<T> action) throws DataAccessException {
        return this.execute(this.newAsyncPreparedStatementCreator(cql), action);
    }

    @Override
    public <T> ListenableFuture<T> execute(AsyncPreparedStatementCreator preparedStatementCreator, PreparedStatementCallback<T> action) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(action, (String)"PreparedStatementCallback object must not be null");
        PersistenceExceptionTranslator exceptionTranslator = ex -> this.translateExceptionIfPossible("PreparedStatementCallback", AsyncCqlTemplate.toCql(preparedStatementCreator), ex);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)AsyncCqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            Session currentSession = this.getCurrentSession();
            return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(preparedStatementCreator.createPreparedStatement(currentSession), preparedStatement -> {
                try {
                    return action.doInPreparedStatement(currentSession, this.applyStatementSettings(preparedStatement));
                }
                catch (DriverException e) {
                    throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
                }
            }), this.getExceptionTranslator());
        }
        catch (DriverException e) {
            throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
        }
    }

    @Override
    public <T> ListenableFuture<T> query(AsyncPreparedStatementCreator preparedStatementCreator, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(preparedStatementCreator, null, resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(AsyncPreparedStatementCreator preparedStatementCreator, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Object> results = this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(AsyncPreparedStatementCreator preparedStatementCreator, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, null, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, final ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        Assert.notNull((Object)preparedStatementCreator, (String)"AsyncPreparedStatementCreator must not be null");
        Assert.notNull(resultSetExtractor, (String)"ResultSetExtractor object must not be null");
        final PersistenceExceptionTranslator exceptionTranslator = ex -> this.translateExceptionIfPossible("Query", AsyncCqlTemplate.toCql(preparedStatementCreator), ex);
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Preparing statement [{}] using {}", (Object)AsyncCqlTemplate.toCql(preparedStatementCreator), (Object)preparedStatementCreator);
            }
            Session session = this.getCurrentSession();
            MappingListenableFutureAdapter statementFuture = new MappingListenableFutureAdapter(preparedStatementCreator.createPreparedStatement(session), preparedStatement -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Executing prepared statement [{}]", preparedStatement);
                }
                return this.applyStatementSettings(psb != null ? psb.bindValues((PreparedStatement)preparedStatement) : preparedStatement.bind());
            });
            final SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
            statementFuture.addCallback(boundStatement -> Futures.addCallback((com.google.common.util.concurrent.ListenableFuture)session.executeAsync((Statement)boundStatement), (FutureCallback)new FutureCallback<ResultSet>(){

                public void onSuccess(@Nullable ResultSet result) {
                    try {
                        settableListenableFuture.set(result != null ? resultSetExtractor.extractData(result) : null);
                    }
                    catch (DriverException e) {
                        settableListenableFuture.setException((Throwable)AsyncCqlTemplate.translateException(exceptionTranslator, e));
                    }
                }

                public void onFailure(Throwable ex) {
                    if (ex instanceof DriverException) {
                        settableListenableFuture.setException((Throwable)AsyncCqlTemplate.translateException(exceptionTranslator, (DriverException)ex));
                    } else {
                        settableListenableFuture.setException(ex);
                    }
                }
            }), ex -> {
                if (ex instanceof DriverException) {
                    settableListenableFuture.setException((Throwable)AsyncCqlTemplate.translateException(exceptionTranslator, (DriverException)ex));
                } else {
                    settableListenableFuture.setException(ex);
                }
            });
            return settableListenableFuture;
        }
        catch (DriverException e) {
            throw AsyncCqlTemplate.translateException(exceptionTranslator, e);
        }
    }

    @Override
    public ListenableFuture<Void> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Object> results = this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(AsyncPreparedStatementCreator preparedStatementCreator, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(preparedStatementCreator, psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, ResultSetExtractor<T> resultSetExtractor, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(String cql, RowCallbackHandler rowCallbackHandler, Object ... args) throws DataAccessException {
        ListenableFuture<Object> results = this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper));
    }

    @Override
    public <T> ListenableFuture<T> query(String cql, @Nullable PreparedStatementBinder psb, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), psb, resultSetExtractor);
    }

    @Override
    public ListenableFuture<Void> query(String cql, @Nullable PreparedStatementBinder psb, RowCallbackHandler rowCallbackHandler) throws DataAccessException {
        ListenableFuture<Object> results = this.query(this.newAsyncPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowCallbackHandler));
        return new ExceptionTranslatingListenableFutureAdapter<Void>((ListenableFuture<Void>)new MappingListenableFutureAdapter(results, o -> null), this.getExceptionTranslator());
    }

    @Override
    public <T> ListenableFuture<List<T>> query(String cql, @Nullable PreparedStatementBinder psb, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), psb, this.newResultSetExtractor(rowMapper));
    }

    @Override
    public ListenableFuture<List<Map<String, Object>>> queryForList(String cql, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newColumnMapRowMapper()));
    }

    @Override
    public <T> ListenableFuture<List<T>> queryForList(String cql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(this.newSingleColumnRowMapper(elementType)));
    }

    @Override
    public ListenableFuture<Map<String, Object>> queryForMap(String cql, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newColumnMapRowMapper(), args);
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return this.queryForObject(cql, this.newSingleColumnRowMapper(requiredType), args);
    }

    @Override
    public <T> ListenableFuture<T> queryForObject(String cql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        ListenableFuture<T> results = this.query(this.newAsyncPreparedStatementCreator(cql), this.newPreparedStatementBinder(args), this.newResultSetExtractor(rowMapper, 1));
        return new ExceptionTranslatingListenableFutureAdapter(new MappingListenableFutureAdapter(results, DataAccessUtils::requiredSingleResult), this.getExceptionTranslator());
    }

    @Override
    public ListenableFuture<ResultSet> queryForResultSet(String cql, Object ... args) throws DataAccessException {
        return this.query(cql, (ResultSet rs) -> rs, args);
    }

    protected AsyncPreparedStatementCreator newAsyncPreparedStatementCreator(String cql) {
        return new SimpleAsyncPreparedStatementCreator(cql, ex -> this.translateExceptionIfPossible("PrepareStatement", cql, ex));
    }

    protected DataAccessException translateException(String task, @Nullable String cql, DriverException ex) {
        return this.translate(task, cql, ex);
    }

    @Nullable
    protected DataAccessException translateExceptionIfPossible(String task, @Nullable String cql, RuntimeException ex) {
        return ex instanceof DriverException ? this.translate(task, cql, (DriverException)((Object)ex)) : null;
    }

    private Session getCurrentSession() {
        SessionFactory sessionFactory = this.getSessionFactory();
        Assert.state((sessionFactory != null ? 1 : 0) != 0, (String)"SessionFactory is null");
        return sessionFactory.getSession();
    }

    private static RuntimeException translateException(PersistenceExceptionTranslator exceptionTranslator, DriverException e) {
        DataAccessException translated = exceptionTranslator.translateExceptionIfPossible((RuntimeException)((Object)e));
        return translated == null ? e : translated;
    }

    private static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        private MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(S adapteeResult) throws ExecutionException {
            return this.mapper.apply(adapteeResult);
        }
    }

    private static class SimpleAsyncPreparedStatementCreator
    implements AsyncPreparedStatementCreator,
    CqlProvider {
        private final PersistenceExceptionTranslator persistenceExceptionTranslator;
        private final String cql;

        private SimpleAsyncPreparedStatementCreator(String cql, PersistenceExceptionTranslator persistenceExceptionTranslator) {
            Assert.hasText((String)cql, (String)"CQL must not be empty");
            this.cql = cql;
            this.persistenceExceptionTranslator = persistenceExceptionTranslator;
        }

        @Override
        public String getCql() {
            return this.cql;
        }

        @Override
        public ListenableFuture<PreparedStatement> createPreparedStatement(Session session) throws DriverException {
            return new GuavaListenableFutureAdapter<PreparedStatement>(session.prepareAsync(this.getCql()), this.persistenceExceptionTranslator);
        }
    }
}

