/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;
import org.threeten.bp.LocalTime;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;

public abstract class CassandraThreeTenBackPortConverters {
    private static final boolean THREE_TEN_BACK_PORT_IS_PRESENT = ClassUtils.isPresent((String)"org.threeten.bp.LocalDateTime", (ClassLoader)ThreeTenBackPortConverters.class.getClassLoader());

    private CassandraThreeTenBackPortConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!THREE_TEN_BACK_PORT_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(CassandraLocalDateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToCassandraLocalDateConverter.INSTANCE);
        converters.add(MillisOfDayToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToMillisOfDayConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    @CassandraType(type=DataType.Name.TIME)
    public static enum LocalTimeToMillisOfDayConverter implements Converter<LocalTime, Long>
    {
        INSTANCE;


        public Long convert(LocalTime source) {
            return source.getLong((TemporalField)ChronoField.MILLI_OF_DAY);
        }
    }

    @ReadingConverter
    public static enum MillisOfDayToLocalTimeConverter implements Converter<Long, LocalTime>
    {
        INSTANCE;


        public LocalTime convert(Long source) {
            return LocalTime.ofNanoOfDay((long)TimeUnit.MILLISECONDS.toNanos(source));
        }
    }

    public static enum LocalDateToCassandraLocalDateConverter implements Converter<org.threeten.bp.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(org.threeten.bp.LocalDate source) {
            return LocalDate.fromYearMonthDay((int)source.getYear(), (int)source.getMonthValue(), (int)source.getDayOfMonth());
        }
    }

    public static enum CassandraLocalDateToLocalDateConverter implements Converter<LocalDate, org.threeten.bp.LocalDate>
    {
        INSTANCE;


        public org.threeten.bp.LocalDate convert(LocalDate source) {
            return org.threeten.bp.LocalDate.of((int)source.getYear(), (int)source.getMonth(), (int)source.getDay());
        }
    }
}

