/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.SimpleStatement;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.repository.query.AbstractReactiveCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveStringBasedCassandraQuery
extends AbstractReactiveCassandraQuery {
    private final StringBasedQuery stringBasedQuery;

    public ReactiveStringBasedCassandraQuery(ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public ReactiveStringBasedCassandraQuery(String query, ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        super(queryMethod, operations);
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.stringBasedQuery = new StringBasedQuery(query, new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider));
    }

    protected StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    public SimpleStatement createQuery(CassandraParameterAccessor parameterAccessor) {
        return this.getQueryStatementCreator().select(this.getStringBasedQuery(), parameterAccessor);
    }
}

