/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.support;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.springframework.data.cassandra.core.cql.support.PreparedStatementCache;
import org.springframework.util.Assert;

public class MapPreparedStatementCache
implements PreparedStatementCache {
    private final Map<CacheKey, PreparedStatement> cache;

    private MapPreparedStatementCache(Map<CacheKey, PreparedStatement> cache) {
        Assert.notNull(cache, (String)"Cache must not be null");
        this.cache = cache;
    }

    public static MapPreparedStatementCache create() {
        return MapPreparedStatementCache.of(new ConcurrentHashMap<CacheKey, PreparedStatement>());
    }

    public static MapPreparedStatementCache of(Map<CacheKey, PreparedStatement> cache) {
        return new MapPreparedStatementCache(cache);
    }

    protected Map<CacheKey, PreparedStatement> getCache() {
        return this.cache;
    }

    @Override
    public PreparedStatement getPreparedStatement(Session session, RegularStatement statement, Supplier<PreparedStatement> preparer) {
        CacheKey cacheKey = new CacheKey(session, statement.toString());
        return this.getCache().computeIfAbsent(cacheKey, key -> (PreparedStatement)preparer.get());
    }

    protected static class CacheKey {
        final Cluster cluster;
        final String keyspace;
        final String cql;

        CacheKey(Session session, String cql) {
            this.cluster = session.getCluster();
            this.keyspace = session.getLoggedKeyspace();
            this.cql = cql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Cluster this$cluster = this.cluster;
            Cluster other$cluster = other.cluster;
            if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
                return false;
            }
            String this$keyspace = this.keyspace;
            String other$keyspace = other.keyspace;
            if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
                return false;
            }
            String this$cql = this.cql;
            String other$cql = other.cql;
            return !(this$cql == null ? other$cql != null : !this$cql.equals(other$cql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cluster $cluster = this.cluster;
            result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
            String $keyspace = this.keyspace;
            result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
            String $cql = this.cql;
            result = result * 59 + ($cql == null ? 43 : $cql.hashCode());
            return result;
        }
    }
}

