/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.Criteria;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Filter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryMapper {
    private final CassandraConverter converter;
    private final CassandraMappingContext mappingContext;

    public QueryMapper(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    protected CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public Filter getMappedObject(Filter filter, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        ArrayList<Criteria> result = new ArrayList<Criteria>();
        for (CriteriaDefinition criteriaDefinition : filter) {
            Field field = this.createPropertyField(entity, criteriaDefinition.getColumnName());
            CriteriaDefinition.Predicate predicate = criteriaDefinition.getPredicate();
            field.getProperty().filter(CassandraPersistentProperty::isCompositePrimaryKey).ifPresent(it -> {
                throw new IllegalArgumentException("Cannot use composite primary key directly. Reference a property of the composite primary key");
            });
            Object value = predicate.getValue();
            TypeInformation<?> typeInformation = this.getTypeInformation(field, value);
            Object mappedValue = value != null ? this.getConverter().convertToColumnType(value, typeInformation) : null;
            CriteriaDefinition.Predicate mappedPredicate = new CriteriaDefinition.Predicate(predicate.getOperator(), mappedValue);
            result.add(Criteria.of(field.getMappedKey(), mappedPredicate));
        }
        return Filter.from(result);
    }

    public List<Columns.Selector> getMappedSelectors(Columns columns, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Columns.Selector> selectors = new ArrayList<Columns.Selector>();
        for (ColumnName column : columns) {
            Field field = this.createPropertyField(entity, column);
            columns.getSelector(column).ifPresent(selector -> this.getCqlIdentifier(column, field).ifPresent(cqlIdentifier -> selectors.add(this.getMappedSelector((Columns.Selector)selector, (CqlIdentifier)cqlIdentifier))));
        }
        if (columns.isEmpty()) {
            this.addColumns(entity, selectors);
        }
        return selectors;
    }

    private void addColumns(CassandraPersistentEntity<?> entity, List<Columns.Selector> selectors) {
        entity.doWithProperties(property -> {
            if (property.isCompositePrimaryKey()) {
                CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(property);
                this.addColumns(primaryKeyEntity, selectors);
            } else {
                selectors.add(Columns.ColumnSelector.from(property.getColumnName().toCql()));
            }
        });
    }

    private Columns.Selector getMappedSelector(Columns.Selector selector, CqlIdentifier cqlIdentifier) {
        if (selector instanceof Columns.ColumnSelector) {
            Columns.ColumnSelector columnSelector = (Columns.ColumnSelector)selector;
            Columns.ColumnSelector mappedColumnSelector = Columns.ColumnSelector.from(cqlIdentifier);
            return columnSelector.getAlias().map(mappedColumnSelector::as).orElse(mappedColumnSelector);
        }
        if (selector instanceof Columns.FunctionCall) {
            Columns.FunctionCall functionCall = (Columns.FunctionCall)selector;
            List mappedParameters = functionCall.getParameters().stream().map(obj -> {
                if (obj instanceof Columns.Selector) {
                    return this.getMappedSelector((Columns.Selector)obj, cqlIdentifier);
                }
                return obj;
            }).collect(Collectors.toList());
            Columns.FunctionCall mappedFunctionCall = Columns.FunctionCall.from(functionCall.getExpression(), mappedParameters.toArray());
            return functionCall.getAlias().map(mappedFunctionCall::as).orElse(mappedFunctionCall);
        }
        throw new IllegalArgumentException(String.format("Selector [%s] not supported", selector));
    }

    public List<String> getMappedColumnNames(Columns columns, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)columns, (String)"Columns must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        HashSet seen = new HashSet();
        for (ColumnName column : columns) {
            Field field = this.createPropertyField(entity, column);
            field.getProperty().ifPresent(seen::add);
            columns.getSelector(column).filter(selector -> selector instanceof Columns.ColumnSelector).ifPresent(columnSelector -> this.getCqlIdentifier(column, field).map(CqlIdentifier::toCql).ifPresent(columnNames::add));
        }
        if (columns.isEmpty()) {
            entity.doWithProperties(property -> {
                if (property.isCompositePrimaryKey()) {
                    return;
                }
                if (seen.add(property)) {
                    columnNames.add(property.getColumnName().toCql());
                }
            });
        }
        return columnNames;
    }

    public Sort getMappedSort(Sort sort, CassandraPersistentEntity<?> entity) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        if (!sort.iterator().hasNext()) {
            return sort;
        }
        ArrayList<Sort.Order> mappedOrders = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            ColumnName columnName = ColumnName.from(order.getProperty());
            Field field = this.createPropertyField(entity, columnName);
            Sort.Order mappedOrder = this.getCqlIdentifier(columnName, field).map(cqlIdentifier -> new Sort.Order(order.getDirection(), cqlIdentifier.toCql())).orElse(order);
            mappedOrders.add(mappedOrder);
        }
        return Sort.by(mappedOrders);
    }

    private Optional<CqlIdentifier> getCqlIdentifier(ColumnName column, Field field) {
        try {
            if (field.getProperty().isPresent()) {
                return field.getProperty().map(cassandraPersistentProperty -> {
                    if (cassandraPersistentProperty.isCompositePrimaryKey()) {
                        throw new IllegalArgumentException("Cannot use composite primary key directly. Reference a property of the composite primary key");
                    }
                    return cassandraPersistentProperty.getColumnName();
                });
            }
            if (column.getColumnName().isPresent()) {
                return column.getColumnName().map(CqlIdentifier::of);
            }
            return column.getCqlIdentifier();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    Field createPropertyField(CassandraPersistentEntity<?> entity, ColumnName key) {
        return Optional.of(entity).map(e -> new MetadataBackedField(key, (CassandraPersistentEntity<?>)e, (MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)this.getMappingContext())).orElseGet(() -> new Field(key));
    }

    TypeInformation<?> getTypeInformation(Field field, @Nullable Object value) {
        if (field.getProperty().isPresent()) {
            return field.getProperty().get().getTypeInformation();
        }
        if (value != null) {
            return ClassTypeInformation.from(value.getClass());
        }
        return ClassTypeInformation.OBJECT;
    }

    protected static class MetadataBackedField
    extends Field {
        private final CassandraPersistentEntity<?> entity;
        private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
        private final Optional<PersistentPropertyPath<CassandraPersistentProperty>> path;
        @Nullable
        private final CassandraPersistentProperty property;
        private final Optional<CassandraPersistentProperty> optionalProperty;

        public MetadataBackedField(ColumnName name, CassandraPersistentEntity<?> entity, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) {
            this(name, entity, mappingContext, null);
        }

        public MetadataBackedField(ColumnName name, CassandraPersistentEntity<?> entity, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, @Nullable CassandraPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
            this.entity = entity;
            this.mappingContext = mappingContext;
            this.path = this.getPath(name.toCql());
            this.property = this.path.map(PersistentPropertyPath::getLeafProperty).orElse(property);
            this.optionalProperty = Optional.ofNullable(this.property);
        }

        private Optional<PersistentPropertyPath<CassandraPersistentProperty>> getPath(String pathExpression) {
            try {
                PropertyPath propertyPath = PropertyPath.from((String)pathExpression.replaceAll("\\.\\d", ""), (TypeInformation)this.entity.getTypeInformation());
                PersistentPropertyPath persistentPropertyPath = this.mappingContext.getPersistentPropertyPath(propertyPath);
                return Optional.of(persistentPropertyPath);
            }
            catch (PropertyReferenceException e) {
                return Optional.empty();
            }
        }

        @Override
        public MetadataBackedField with(ColumnName name) {
            return new MetadataBackedField(name, this.entity, this.mappingContext, this.property);
        }

        @Override
        public Optional<CassandraPersistentProperty> getProperty() {
            return this.optionalProperty;
        }

        @Override
        public ColumnName getMappedKey() {
            return this.path.map(PersistentPropertyPath::getLeafProperty).map(CassandraPersistentProperty::getColumnName).map(ColumnName::from).orElse(this.name);
        }
    }

    protected static class Field {
        protected final ColumnName name;

        Field(ColumnName name) {
            Assert.notNull((Object)name, (String)"Name must not be null!");
            this.name = name;
        }

        public Field with(ColumnName name) {
            return new Field(name);
        }

        public Optional<CassandraPersistentProperty> getProperty() {
            return Optional.empty();
        }

        public ColumnName getMappedKey() {
            return this.name;
        }
    }
}

