/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ThreeTenBackPortConverters;
import org.springframework.util.ClassUtils;
import org.threeten.bp.LocalDate;

public abstract class CassandraThreeTenBackPortConverters {
    private static final boolean THREE_TEN_BACK_PORT_IS_PRESENT = ClassUtils.isPresent((String)"org.threeten.bp.LocalDateTime", (ClassLoader)ThreeTenBackPortConverters.class.getClassLoader());

    private CassandraThreeTenBackPortConverters() {
    }

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!THREE_TEN_BACK_PORT_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(CassandraLocalDateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToCassandraLocalDateConverter.INSTANCE);
        return converters;
    }

    public static enum LocalDateToCassandraLocalDateConverter implements Converter<LocalDate, com.datastax.driver.core.LocalDate>
    {
        INSTANCE;


        public com.datastax.driver.core.LocalDate convert(LocalDate source) {
            return com.datastax.driver.core.LocalDate.fromYearMonthDay((int)source.getYear(), (int)source.getMonthValue(), (int)source.getDayOfMonth());
        }
    }

    public static enum CassandraLocalDateToLocalDateConverter implements Converter<com.datastax.driver.core.LocalDate, LocalDate>
    {
        INSTANCE;


        public LocalDate convert(com.datastax.driver.core.LocalDate source) {
            return LocalDate.of((int)source.getYear(), (int)source.getMonth(), (int)source.getDay());
        }
    }
}

