/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TypeCodec;
import java.util.Iterator;
import java.util.Set;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

class ConvertingParameterAccessor
implements CassandraParameterAccessor {
    private static final TypeInformation<Set> SET = ClassTypeInformation.from(Set.class);
    private final CassandraConverter converter;
    private final CassandraParameterAccessor delegate;

    ConvertingParameterAccessor(CassandraConverter converter, CassandraParameterAccessor delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Class<?> getDynamicProjection() {
        return this.delegate.getDynamicProjection();
    }

    public Object getBindableValue(int index) {
        return this.potentiallyConvert(index, this.delegate.getBindableValue(index), null);
    }

    @Override
    public DataType getDataType(int index) {
        DataType dataType = this.delegate.getDataType(index);
        return dataType != null ? dataType : this.converter.getMappingContext().getDataType(this.getParameterType(index));
    }

    @Override
    public CassandraType findCassandraType(int index) {
        return this.delegate.findCassandraType(index);
    }

    @Override
    public Class<?> getParameterType(int index) {
        return this.delegate.getParameterType(index);
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    private Object potentiallyConvert(int index, Object bindableValue, CassandraPersistentProperty property) {
        return bindableValue == null ? null : this.converter.convertToCassandraColumn(bindableValue, this.findTypeInformation(index, bindableValue, property));
    }

    private TypeInformation<?> findTypeInformation(int index, Object bindableValue, CassandraPersistentProperty property) {
        if (this.delegate.findCassandraType(index) != null) {
            TypeCodec typeCodec = CodecRegistry.DEFAULT_INSTANCE.codecFor(this.getDataType(index, property));
            if (typeCodec.getJavaType().getType() instanceof Class) {
                return ClassTypeInformation.from((Class)((Class)typeCodec.getJavaType().getType()));
            }
            return ClassTypeInformation.from((Class)typeCodec.getJavaType().getRawType());
        }
        if (property == null) {
            return ClassTypeInformation.from(bindableValue.getClass());
        }
        return property.getTypeInformation();
    }

    DataType getDataType(int index, CassandraPersistentProperty property) {
        DataType.CollectionType collectionType;
        CassandraType cassandraType = this.delegate.findCassandraType(index);
        if (cassandraType != null) {
            return CassandraSimpleTypeHolder.getDataTypeFor(cassandraType.type());
        }
        CassandraMappingContext mappingContext = this.converter.getMappingContext();
        ClassTypeInformation typeInformation = ClassTypeInformation.from(this.getParameterType(index));
        if (property == null) {
            return mappingContext.getDataType(typeInformation.getType());
        }
        DataType dataType = mappingContext.getDataType(property);
        if (property.isCollectionLike() && !typeInformation.isCollectionLike() && dataType instanceof DataType.CollectionType && (collectionType = (DataType.CollectionType)dataType).getTypeArguments().size() == 1) {
            return (DataType)collectionType.getTypeArguments().get(0);
        }
        if (!property.isCollectionLike() && typeInformation.isCollectionLike()) {
            if (typeInformation.isAssignableFrom(SET)) {
                return DataType.set((DataType)dataType);
            }
            return DataType.list((DataType)dataType);
        }
        if (property.isMap() && dataType instanceof DataType.CollectionType && (collectionType = (DataType.CollectionType)dataType).getTypeArguments().size() == 2) {
            return (DataType)collectionType.getTypeArguments().get(0);
        }
        return mappingContext.getDataType(property);
    }

    static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public Object nextConverted(CassandraPersistentProperty var1);
    }

    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;
        private int index = 0;

        ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next(), null);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public Object nextConverted(CassandraPersistentProperty property) {
            return ConvertingParameterAccessor.this.potentiallyConvert(this.index++, this.delegate.next(), property);
        }
    }
}

