/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;

public class CassandraSimpleTypeHolder
extends SimpleTypeHolder {
    public static final Set<Class<?>> CASSANDRA_SIMPLE_TYPES;
    private static final Map<Class<?>, DataType> classToDataType;
    private static final Map<DataType.Name, DataType> nameToDataType;
    public static final SimpleTypeHolder HOLDER;

    private static Map<DataType.Name, DataType> nameToDataType() {
        HashMap<DataType.Name, DataType> nameToDataType = new HashMap<DataType.Name, DataType>(16);
        for (DataType dataType : DataType.allPrimitiveTypes()) {
            nameToDataType.put(dataType.getName(), dataType);
        }
        return nameToDataType;
    }

    private static Map<Class<?>, DataType> classToDataType(Map<Class<?>, Class<?>> primitiveWrappers, CodecRegistry codecRegistry) {
        HashMap classToDataType = new HashMap(16);
        for (DataType dataType : DataType.allPrimitiveTypes()) {
            Class javaClass = codecRegistry.codecFor(dataType).getJavaType().getRawType();
            classToDataType.put(javaClass, dataType);
            Class<?> primitiveJavaClass = primitiveWrappers.get(javaClass);
            if (primitiveJavaClass == null) continue;
            classToDataType.put(primitiveJavaClass, dataType);
        }
        classToDataType.put(String.class, DataType.text());
        classToDataType.put(Long.class, DataType.bigint());
        classToDataType.put(Long.TYPE, DataType.bigint());
        return classToDataType;
    }

    private static Set<Class<?>> getCassandraPrimitiveTypes(CodecRegistry codecRegistry) {
        HashSet simpleTypes = new HashSet();
        for (DataType dataType : DataType.allPrimitiveTypes()) {
            Class javaClass = codecRegistry.codecFor(dataType).getJavaType().getRawType();
            simpleTypes.add(javaClass);
        }
        return simpleTypes;
    }

    public static DataType getDataTypeFor(DataType.Name name) {
        return nameToDataType.get(name);
    }

    public static DataType getDataTypeFor(Class<?> javaClass) {
        if (javaClass.isEnum()) {
            return DataType.varchar();
        }
        return classToDataType.get(javaClass);
    }

    public static DataType.Name[] getDataTypeNamesFrom(List<TypeInformation<?>> arguments) {
        DataType.Name[] array = new DataType.Name[arguments.size()];
        for (int i = 0; i != array.length; ++i) {
            TypeInformation<?> typeInfo = arguments.get(i);
            DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(typeInfo.getType());
            if (dataType == null) {
                throw new InvalidDataAccessApiUsageException(String.format("Did not find appropriate primitive DataType for type '%s'", typeInfo.getType()));
            }
            array[i] = dataType.getName();
        }
        return array;
    }

    public CassandraSimpleTypeHolder() {
        super(CASSANDRA_SIMPLE_TYPES, true);
    }

    static {
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        HashMap primitiveWrappers = new HashMap(8);
        primitiveWrappers.put(Boolean.class, Boolean.TYPE);
        primitiveWrappers.put(Byte.class, Byte.TYPE);
        primitiveWrappers.put(Character.class, Character.TYPE);
        primitiveWrappers.put(Double.class, Double.TYPE);
        primitiveWrappers.put(Float.class, Float.TYPE);
        primitiveWrappers.put(Integer.class, Integer.TYPE);
        primitiveWrappers.put(Long.class, Long.TYPE);
        primitiveWrappers.put(Short.class, Short.TYPE);
        Set<Class<?>> simpleTypes = CassandraSimpleTypeHolder.getCassandraPrimitiveTypes(codecRegistry);
        simpleTypes.add(Number.class);
        simpleTypes.add(Row.class);
        simpleTypes.add(UDTValue.class);
        classToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.classToDataType(primitiveWrappers, codecRegistry));
        nameToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.nameToDataType());
        CASSANDRA_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new CassandraSimpleTypeHolder();
    }
}

