/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.PartTreeCassandraQuery;
import org.springframework.data.cassandra.repository.query.StringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.SimpleCassandraRepository;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class CassandraRepositoryFactory
extends RepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final CassandraMappingContext mappingContext;
    private final CassandraOperations operations;

    public CassandraRepositoryFactory(CassandraOperations operations) {
        Assert.notNull((Object)operations, (String)"CassandraOperations must not be null");
        this.operations = operations;
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    public <T, ID extends Serializable> CassandraEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s", domainClass.getName()));
        }
        return new MappingCassandraEntityInformation(entity, this.operations.getConverter());
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return this.getQueryLookupStrategy(key, null);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new CassandraQueryLookupStrategy(this.operations, evaluationContextProvider, this.mappingContext);
    }

    private class CassandraQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EvaluationContextProvider evaluationContextProvider;
        private final CassandraMappingContext mappingContext;
        private final CassandraOperations operations;

        public CassandraQueryLookupStrategy(CassandraOperations operations, EvaluationContextProvider evaluationContextProvider, CassandraMappingContext mappingContext) {
            this.operations = operations;
            this.evaluationContextProvider = evaluationContextProvider;
            this.mappingContext = mappingContext;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CassandraQueryMethod queryMethod = new CassandraQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedCassandraQuery(namedQuery, queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedCassandraQuery(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            return new PartTreeCassandraQuery(queryMethod, this.operations);
        }
    }
}

