/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.cassandra.config.CassandraCqlSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaCreator;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaDropper;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.util.Assert;

public class CassandraSessionFactoryBean
extends CassandraCqlSessionFactoryBean {
    protected static final boolean DEFAULT_CREATE_IF_NOT_EXISTS = false;
    protected static final boolean DEFAULT_DROP_TABLES = false;
    protected static final boolean DEFAULT_DROP_UNUSED_TABLES = false;
    private CassandraAdminOperations admin;
    private CassandraConverter converter;
    private SchemaAction schemaAction = SchemaAction.NONE;

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
    }

    public CassandraConverter getConverter() {
        return this.converter;
    }

    protected CassandraMappingContext getMappingContext() {
        return this.getConverter().getMappingContext();
    }

    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction), (String)"SchemaAction must not be null");
        this.schemaAction = schemaAction;
    }

    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"Converter was not properly initialized");
        super.afterPropertiesSet();
        this.admin = new CassandraAdminTemplate(this.getObject(), this.converter);
        this.performSchemaAction();
    }

    protected void performSchemaAction() {
        boolean create = false;
        boolean drop = false;
        boolean dropUnused = false;
        boolean ifNotExists = false;
        switch (this.schemaAction) {
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                drop = true;
            }
            case CREATE_IF_NOT_EXISTS: {
                ifNotExists = SchemaAction.CREATE_IF_NOT_EXISTS.equals((Object)this.schemaAction);
            }
            case CREATE: {
                create = true;
            }
        }
        if (create) {
            this.createTables(drop, dropUnused, ifNotExists);
        }
    }

    protected void createTables(boolean drop, boolean dropUnused, boolean ifNotExists) {
        this.performSchemaActions(drop, dropUnused, ifNotExists);
    }

    private void performSchemaActions(boolean drop, boolean dropUnused, boolean ifNotExists) {
        CassandraPersistentEntitySchemaCreator schemaCreator = new CassandraPersistentEntitySchemaCreator(this.getMappingContext(), this.getCassandraAdminOperations());
        if (drop) {
            CassandraPersistentEntitySchemaDropper schemaDropper = new CassandraPersistentEntitySchemaDropper(this.getMappingContext(), this.getCassandraAdminOperations());
            schemaDropper.dropTables(dropUnused);
            schemaDropper.dropUserTypes(dropUnused);
        }
        schemaCreator.createUserTypes(ifNotExists);
        schemaCreator.createTables(ifNotExists);
    }

    protected CassandraAdminOperations getCassandraAdminOperations() {
        return this.admin;
    }
}

