/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cassandra.core.Ordering;
import org.springframework.cassandra.core.PrimaryKeyType;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.mapping.Column;
import org.springframework.data.cassandra.mapping.Indexed;
import org.springframework.data.cassandra.mapping.PrimaryKey;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.mapping.UserTypeResolver;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentProperty
extends AnnotationBasedPersistentProperty<CassandraPersistentProperty>
implements CassandraPersistentProperty,
ApplicationContextAware {
    protected ApplicationContext context;
    protected Boolean forceQuote;
    protected List<CqlIdentifier> columnNames;
    protected List<CqlIdentifier> explicitColumnNames;
    protected StandardEvaluationContext spelContext;
    private final UserTypeResolver userTypeResolver;

    public BasicCassandraPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, CassandraPersistentEntity<?> owner, CassandraSimpleTypeHolder simpleTypeHolder) {
        this(field, propertyDescriptor, owner, simpleTypeHolder, null);
    }

    public BasicCassandraPersistentProperty(Field field, PropertyDescriptor propertyDescriptor, CassandraPersistentEntity<?> owner, CassandraSimpleTypeHolder simpleTypeHolder, UserTypeResolver userTypeResolver) {
        super(field, propertyDescriptor, owner, (SimpleTypeHolder)simpleTypeHolder);
        this.userTypeResolver = userTypeResolver;
        if (owner.getApplicationContext() != null) {
            this.setApplicationContext(owner.getApplicationContext());
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context);
        this.context = context;
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public CassandraPersistentEntity<?> getOwner() {
        return (CassandraPersistentEntity)super.getOwner();
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.getType(), PrimaryKeyClass.class) != null;
    }

    public Class<?> getCompositePrimaryKeyType() {
        return this.isCompositePrimaryKey() ? this.getType() : null;
    }

    @Override
    public TypeInformation<?> getCompositePrimaryKeyTypeInformation() {
        return this.isCompositePrimaryKey() ? ClassTypeInformation.from(this.getCompositePrimaryKeyType()) : null;
    }

    @Override
    public CqlIdentifier getColumnName() {
        List<CqlIdentifier> columnNames = this.getColumnNames();
        Assert.state((columnNames.size() == 1 ? 1 : 0) != 0, (String)String.format("Property [%s] has no single column mapping", this.getName()));
        return columnNames.get(0);
    }

    @Override
    public Ordering getPrimaryKeyOrdering() {
        PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return primaryKeyColumn != null ? primaryKeyColumn.ordering() : null;
    }

    @Override
    public DataType getDataType() {
        DataType dataType = this.findDataType();
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Unknown type [%s] for property [%s] in entity [%s]; only primitive types and Collections or Maps of primitive types are allowed", this.getType(), this.getName(), this.getOwner().getName()));
        }
        return dataType;
    }

    private DataType findDataType() {
        CassandraType cassandraType = (CassandraType)this.findAnnotation(CassandraType.class);
        if (cassandraType != null) {
            return this.getDataTypeFor(cassandraType);
        }
        if (this.isMap()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.ensureTypeArguments(args.size(), 2);
            return DataType.map((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()), (DataType)this.getDataTypeFor(((TypeInformation)args.get(1)).getType()));
        }
        if (this.isCollectionLike()) {
            List args = this.getTypeInformation().getTypeArguments();
            this.ensureTypeArguments(args.size(), 1);
            if (Set.class.isAssignableFrom(this.getType())) {
                return DataType.set((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
            if (List.class.isAssignableFrom(this.getType())) {
                return DataType.list((DataType)this.getDataTypeFor(((TypeInformation)args.get(0)).getType()));
            }
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(this.getType());
    }

    private DataType getDataTypeFor(CassandraType annotation) {
        DataType.Name type = annotation.type();
        switch (type) {
            case MAP: {
                this.ensureTypeArguments(annotation.typeArguments().length, 2);
                return DataType.map((DataType)this.getDataTypeFor(annotation.typeArguments()[0]), (DataType)this.getDataTypeFor(annotation.typeArguments()[1]));
            }
            case LIST: {
                this.ensureTypeArguments(annotation.typeArguments().length, 1);
                if (annotation.typeArguments()[0] == DataType.Name.UDT) {
                    return DataType.list((DataType)this.getUserType(annotation));
                }
                return DataType.list((DataType)this.getDataTypeFor(annotation.typeArguments()[0]));
            }
            case SET: {
                this.ensureTypeArguments(annotation.typeArguments().length, 1);
                if (annotation.typeArguments()[0] == DataType.Name.UDT) {
                    return DataType.set((DataType)this.getUserType(annotation));
                }
                return DataType.set((DataType)this.getDataTypeFor(annotation.typeArguments()[0]));
            }
            case UDT: {
                return this.getUserType(annotation);
            }
        }
        return CassandraSimpleTypeHolder.getDataTypeFor(type);
    }

    private DataType getUserType(CassandraType annotation) {
        if (!StringUtils.hasText((String)annotation.userTypeName())) {
            throw new InvalidDataAccessApiUsageException(String.format("Expected user type name in property ['%s'] of type ['%s'] in entity [%s]", this.getName(), this.getType(), this.getOwner().getName()));
        }
        CqlIdentifier identifier = CqlIdentifier.cqlId((CharSequence)annotation.userTypeName());
        UserType userType = this.userTypeResolver.resolveType(identifier);
        if (userType == null) {
            throw new MappingException(String.format("User type [%s] not found", identifier));
        }
        return userType;
    }

    @Override
    public boolean isIndexed() {
        return this.isAnnotationPresent(Indexed.class);
    }

    @Override
    public boolean isClusterKeyColumn() {
        PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return primaryKeyColumn != null && PrimaryKeyType.CLUSTERED.equals((Object)primaryKeyColumn.type());
    }

    @Override
    public boolean isPartitionKeyColumn() {
        PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
        return primaryKeyColumn != null && PrimaryKeyType.PARTITIONED.equals((Object)primaryKeyColumn.type());
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return this.isAnnotationPresent(PrimaryKeyColumn.class);
    }

    protected DataType getDataTypeFor(DataType.Name dataTypeName) {
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(dataTypeName);
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Only primitive types are allowed inside Collections for property [%1$s] of type [%2$s] in entity [%3$s]", this.getName(), this.getType(), this.getOwner().getName()));
        }
        return dataType;
    }

    protected DataType getDataTypeFor(Class<?> javaType) {
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getOwner().getMappingContext().getPersistentEntity(javaType);
        if (persistentEntity != null && persistentEntity.isUserDefinedType()) {
            return persistentEntity.getUserType();
        }
        DataType dataType = CassandraSimpleTypeHolder.getDataTypeFor(javaType);
        if (dataType == null) {
            throw new InvalidDataAccessApiUsageException(String.format("Only primitive types are allowed inside Collections for property [%1$s] of type ['%2$s'] in entity [%3$s]", this.getName(), this.getType(), this.getOwner().getName()));
        }
        return dataType;
    }

    protected void ensureTypeArguments(int args, int expected) {
        if (args != expected) {
            throw new InvalidDataAccessApiUsageException(String.format("Expected [%1$s] typed arguments for property ['%2$s'] of type ['%3$s'] in entity [%4$s]", expected, this.getName(), this.getType(), this.getOwner().getName()));
        }
    }

    @Override
    public List<CqlIdentifier> getColumnNames() {
        this.columnNames = this.columnNames != null ? this.columnNames : Collections.unmodifiableList(this.determineColumnNames());
        return this.columnNames;
    }

    protected List<CqlIdentifier> determineColumnNames() {
        ArrayList<CqlIdentifier> columnNames = new ArrayList<CqlIdentifier>();
        if (this.isCompositePrimaryKey()) {
            this.addCompositePrimaryKeyColumnNames(this.getCompositePrimaryKeyEntity(), columnNames);
        } else {
            boolean forceQuote;
            String overriddenName;
            String defaultName = this.getName();
            if (this.isIdProperty()) {
                PrimaryKey primaryKey = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
                overriddenName = primaryKey == null ? null : primaryKey.value();
                forceQuote = primaryKey != null && primaryKey.forceQuote();
            } else if (this.isPrimaryKeyColumn()) {
                PrimaryKeyColumn primaryKeyColumn = (PrimaryKeyColumn)this.findAnnotation(PrimaryKeyColumn.class);
                overriddenName = primaryKeyColumn == null ? null : primaryKeyColumn.name();
                forceQuote = primaryKeyColumn != null && primaryKeyColumn.forceQuote();
            } else {
                Column column = (Column)this.findAnnotation(Column.class);
                overriddenName = column == null ? null : column.value();
                forceQuote = column != null && column.forceQuote();
            }
            columnNames.add(this.createColumnName(defaultName, overriddenName, forceQuote));
        }
        return columnNames;
    }

    protected CqlIdentifier createColumnName(String defaultName, String overriddenName, boolean forceQuote) {
        String name = defaultName;
        if (StringUtils.hasText((String)overriddenName)) {
            name = this.spelContext != null ? SpelUtils.evaluate(overriddenName, (EvaluationContext)this.spelContext) : overriddenName;
        }
        return CqlIdentifier.cqlId((CharSequence)name, (boolean)forceQuote);
    }

    protected void addCompositePrimaryKeyColumnNames(CassandraPersistentEntity<?> compositePrimaryKeyEntity, final List<CqlIdentifier> columnNames) {
        compositePrimaryKeyEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isCompositePrimaryKey()) {
                    BasicCassandraPersistentProperty.this.addCompositePrimaryKeyColumnNames(property.getCompositePrimaryKeyEntity(), columnNames);
                } else {
                    columnNames.add(property.getColumnName());
                }
            }
        });
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        Assert.notNull((Object)columnName, (String)"columnName must not be null");
        this.setColumnNames(Collections.singletonList(columnName));
    }

    @Override
    public void setColumnNames(List<CqlIdentifier> columnNames) {
        Assert.notNull(columnNames);
        this.getColumnNames();
        Assert.state((this.columnNames.size() == columnNames.size() ? 1 : 0) != 0, (String)String.format("Property [%s] of entity [%s] is mapped to [%s] column%s, but given column name list has size [%s]", this.getName(), this.getOwner().getType().getName(), this.columnNames.size(), this.columnNames.size() == 1 ? "" : "s", columnNames.size()));
        this.explicitColumnNames = Collections.unmodifiableList(new ArrayList<CqlIdentifier>(columnNames));
        this.columnNames = this.explicitColumnNames;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        if (this.forceQuote != null && this.forceQuote == forceQuote) {
            return;
        }
        this.forceQuote = forceQuote;
        ArrayList<CqlIdentifier> columnNames = new ArrayList<CqlIdentifier>(this.columnNames == null ? 0 : this.columnNames.size());
        for (CqlIdentifier columnName : this.getColumnNames()) {
            columnNames.add(CqlIdentifier.cqlId((CharSequence)columnName.getUnquoted(), (boolean)forceQuote));
        }
        this.setColumnNames(columnNames);
    }

    @Override
    public List<CassandraPersistentProperty> getCompositePrimaryKeyProperties() {
        Assert.state((boolean)this.isCompositePrimaryKey(), (String)String.format("[%s] does not represent a composite primary key property", this.getName()));
        return this.getCompositePrimaryKeyEntity().getCompositePrimaryKeyProperties();
    }

    @Override
    public CassandraPersistentEntity<?> getCompositePrimaryKeyEntity() {
        CassandraMappingContext mappingContext = this.getOwner().getMappingContext();
        Assert.state((mappingContext != null ? 1 : 0) != 0, (String)"CassandraMappingContext needed");
        return (CassandraPersistentEntity)mappingContext.getPersistentEntity(this.getCompositePrimaryKeyTypeInformation());
    }

    public Association<CassandraPersistentProperty> getAssociation() {
        throw new UnsupportedOperationException("Cassandra does not support associations");
    }

    protected Association<CassandraPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isMapLike() {
        return ClassUtils.isAssignable(Map.class, (Class)this.getType());
    }
}

