/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateUserTypeCqlGenerator;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class CassandraPersistentEntitySchemaCreator {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaCreator(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)mappingContext, (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void createTables(boolean ifNotExists) {
        List<CreateTableSpecification> specifications = this.createTableSpecifications(ifNotExists);
        for (CreateTableSpecification specification : specifications) {
            this.cassandraAdminOperations.execute(CreateTableCqlGenerator.toCql((CreateTableSpecification)specification));
        }
    }

    protected List<CreateTableSpecification> createTableSpecifications(boolean ifNotExists) {
        ArrayList entities = new ArrayList(this.mappingContext.getTableEntities());
        ArrayList<CreateTableSpecification> specifications = new ArrayList<CreateTableSpecification>();
        for (CassandraPersistentEntity cassandraPersistentEntity : entities) {
            specifications.add(this.mappingContext.getCreateTableSpecificationFor(cassandraPersistentEntity).ifNotExists(ifNotExists));
        }
        return specifications;
    }

    public void createUserTypes(boolean ifNotExists) {
        List<CreateUserTypeSpecification> specifications = this.createUserTypeSpecifications(ifNotExists);
        for (CreateUserTypeSpecification specification : specifications) {
            this.cassandraAdminOperations.execute(CreateUserTypeCqlGenerator.toCql((CreateUserTypeSpecification)specification));
        }
    }

    protected List<CreateUserTypeSpecification> createUserTypeSpecifications(boolean ifNotExists) {
        ArrayList entities = new ArrayList(this.mappingContext.getUserDefinedTypeEntities());
        HashMap<CqlIdentifier, CassandraPersistentEntity> byTableName = new HashMap<CqlIdentifier, CassandraPersistentEntity>();
        for (CassandraPersistentEntity cassandraPersistentEntity : entities) {
            byTableName.put(cassandraPersistentEntity.getTableName(), cassandraPersistentEntity);
        }
        ArrayList<CreateUserTypeSpecification> specifications = new ArrayList<CreateUserTypeSpecification>();
        HashSet<CqlIdentifier> hashSet = new HashSet<CqlIdentifier>();
        for (CassandraPersistentEntity cassandraPersistentEntity : entities) {
            LinkedHashSet<CqlIdentifier> seen = new LinkedHashSet<CqlIdentifier>();
            seen.add(cassandraPersistentEntity.getTableName());
            this.visitUserTypes(cassandraPersistentEntity, seen);
            ArrayList<CqlIdentifier> ordered = new ArrayList<CqlIdentifier>(seen);
            Collections.reverse(ordered);
            for (CqlIdentifier identifier : ordered) {
                if (!hashSet.add(identifier)) continue;
                specifications.add(this.mappingContext.getCreateUserTypeSpecificationFor((CassandraPersistentEntity)byTableName.get(identifier)).ifNotExists(ifNotExists));
            }
        }
        return specifications;
    }

    private void visitUserTypes(CassandraPersistentEntity<?> entity, final Set<CqlIdentifier> seen) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty persistentProperty) {
                CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)CassandraPersistentEntitySchemaCreator.this.mappingContext.getPersistentEntity(persistentProperty);
                if (persistentEntity != null && persistentEntity.isUserDefinedType() && seen.add(persistentEntity.getTableName())) {
                    CassandraPersistentEntitySchemaCreator.this.visitUserTypes(persistentEntity, seen);
                }
            }
        });
    }
}

