/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.cassandra.repository.support.IdInterfaceValidator;
import org.springframework.data.cassandra.repository.support.MapIdProxyDelegate;
import org.springframework.util.Assert;

public class MapIdFactory {
    public static <T> T id(Class<T> idInterface) {
        Assert.notNull(idInterface);
        return MapIdFactory.id(idInterface, idInterface.getClassLoader());
    }

    public static <T> T id(Class<T> idInterface, ClassLoader loader) {
        if (MapId.class.equals(idInterface)) {
            return (T)new BasicMapId();
        }
        IdInterfaceValidator.validate(idInterface);
        Class<?>[] interfaces = idInterface.getInterfaces();
        switch (interfaces.length) {
            case 0: {
                interfaces = new Class[]{idInterface, MapId.class, Serializable.class};
                break;
            }
            case 1: {
                Class other = interfaces[0].equals(Serializable.class) ? MapId.class : Serializable.class;
                interfaces = new Class[]{idInterface, interfaces[0], other};
                break;
            }
            default: {
                interfaces = new Class[]{idInterface, interfaces[0], interfaces[1]};
            }
        }
        return (T)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new MapIdProxyDelegate(idInterface));
    }
}

