/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.support.IdInterfaceException;
import org.springframework.data.cassandra.repository.support.IdInterfaceExceptions;

public class IdInterfaceValidator {
    public static void validate(Class<?> id) {
        Class<?>[] interfaces;
        IdInterfaceExceptions x = new IdInterfaceExceptions(id);
        if (!id.isInterface()) {
            x.add(new IdInterfaceException(id, null, "id type must be an interface"));
        }
        if ((interfaces = id.getInterfaces()).length > 2 || interfaces.length == 1 && !interfaces[0].equals(Serializable.class) && !interfaces[0].equals(MapId.class)) {
            x.add(new IdInterfaceException(id, null, "id type may only extend Serializable and/or MapId"));
        }
        block4: for (Method m : id.getDeclaredMethods()) {
            Class<?>[] args = m.getParameterTypes();
            String name = m.getName();
            Class<?> ret = m.getReturnType();
            switch (args.length) {
                case 0: {
                    if (name.startsWith("get") && name.length() == 3) {
                        x.add(new IdInterfaceException(id, m, "getter methods must have a property name following 'get' prefix"));
                    }
                    if (Serializable.class.isAssignableFrom(ret)) continue block4;
                    x.add(new IdInterfaceException(id, m, "getter methods must return Serializable types"));
                    continue block4;
                }
                case 1: {
                    Class<?> arg;
                    if (name.startsWith("set") && name.length() == 3) {
                        x.add(new IdInterfaceException(id, m, "setter methods must have a property name following 'set' prefix"));
                    }
                    if (name.startsWith("with") && name.length() == 4) {
                        x.add(new IdInterfaceException(id, m, "setter methods must have a property name following 'with' prefix"));
                    }
                    if (!Void.TYPE.equals(ret) && !id.equals(ret)) {
                        x.add(new IdInterfaceException(id, m, "setter methods not returning void may only return the same type as their id interface"));
                    }
                    if (Serializable.class.isAssignableFrom(arg = args[0])) continue block4;
                    x.add(new IdInterfaceException(id, m, "setter methods must take exactly one Serializable type"));
                    continue block4;
                }
                default: {
                    x.add(new IdInterfaceException(id, m, "id interface methods may only take zero parameters for a getter or one parameter for a setter; found " + args.length));
                }
            }
        }
        if (x.getCount() > 0) {
            throw x;
        }
    }
}

