/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedCassandraQuery;
import org.springframework.data.cassandra.repository.support.MappingCassandraEntityInformation;
import org.springframework.data.cassandra.repository.support.SimpleCassandraRepository;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public class CassandraRepositoryFactory
extends RepositoryFactorySupport {
    private final CassandraOperations cassandraOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraRepositoryFactory(CassandraOperations cassandraOperations) {
        Assert.notNull((Object)cassandraOperations);
        this.cassandraOperations = cassandraOperations;
        this.mappingContext = cassandraOperations.getConverter().getMappingContext();
        this.setQueryLookupStrategyKey(QueryLookupStrategy.Key.USE_DECLARED_QUERY);
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleCassandraRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.cassandraOperations});
    }

    public <T, ID extends Serializable> CassandraEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return new MappingCassandraEntityInformation(entity, this.cassandraOperations.getConverter());
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new CassandraQueryLookupStrategy();
    }

    private class CassandraQueryLookupStrategy
    implements QueryLookupStrategy {
        private CassandraQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            CassandraQueryMethod queryMethod = new CassandraQueryMethod(method, metadata, CassandraRepositoryFactory.this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedCassandraQuery(namedQuery, queryMethod, CassandraRepositoryFactory.this.cassandraOperations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedCassandraQuery(queryMethod, CassandraRepositoryFactory.this.cassandraOperations);
            }
            throw new InvalidDataAccessApiUsageException("declarative query methods are a todo");
        }
    }
}

